<?php
// config.php - إعدادات الاتصال بالبيانات ودوال مساعدة
session_start();

$DB_HOST = '127.0.0.1';
$DB_USER = 'root';
$DB_PASS = ']]12ISzBaO8gBGB_';
$DB_NAME = 'lastship';

$mysqli = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
if ($mysqli->connect_errno) {
    die("فشل الاتصال بقاعدة البيانات: " . $mysqli->connect_error);
}
$mysqli->set_charset('utf8mb4');

// دوال مساعدة
function json_post($k){ return isset($_POST[$k]) ? $_POST[$k] : null; }
function now(){ return date('Y-m-d H:i:s'); }
function sanitize($input) { return htmlspecialchars(strip_tags(trim($input))); }

function get_last_balance($mysqli, $account_type, $account_id){
    $sql = "SELECT balance_after FROM transactions WHERE account_type=? AND account_id=? ORDER BY id DESC LIMIT 1";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param('si', $account_type, $account_id);
    $stmt->execute();
    $stmt->bind_result($balance);
    if($stmt->fetch()){ $stmt->close(); return (float)$balance; }
    $stmt->close();
    return 0.00;
}

function insert_transaction($mysqli, $date, $account_type, $voucher_type, $account_id, $related_invoice_id, $related_voucher_id, $debit, $credit, $description, $payment_method){
    $last = get_last_balance($mysqli, $account_type, $account_id);
    $new_balance = $last + (float)$debit - (float)$credit;
    $sql = "INSERT INTO transactions (date, account_type, voucher_type, account_id, related_invoice_id, related_voucher_id, debit_amount, credit_amount, description, balance_after, created_at, payment_method)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $mysqli->prepare($sql);
    $created_at = date('Y-m-d H:i:s');
    $stmt->bind_param('sssiiiddsdss', $date, $account_type, $voucher_type, $account_id, $related_invoice_id, $related_voucher_id, $debit, $credit, $description, $new_balance, $created_at, $payment_method);
    if(!$stmt->execute()){
        error_log('insert_transaction error: '.$stmt->error);
    }
    $stmt->close();
    return $new_balance;
}

function log_activity($mysqli, $user_id, $action, $entity_type, $entity_id, $old_values, $new_values){
    $sql = "INSERT INTO activity_logs (user_id, action, entity_type, entity_id, old_values, new_values, ip_address, user_agent, created_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $mysqli->prepare($sql);
    $ip = $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
    $created_at = date('Y-m-d H:i:s');
    $stmt->bind_param('ississsss', $user_id, $action, $entity_type, $entity_id, $old_values, $new_values, $ip, $ua, $created_at);
    $stmt->execute();
    $stmt->close();
}

function update_container_balance($mysqli, $table, $id, $new_balance){
    $sql = "UPDATE $table SET current_balance = ?, updated_at = ? WHERE id = ?";
    $stmt = $mysqli->prepare($sql);
    $t = date('Y-m-d H:i:s');
    $stmt->bind_param('dsi', $new_balance, $t, $id);
    $stmt->execute();
    $stmt->close();
}

function current_user_id(){
    return isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 1;
}

function get_cash_boxes($mysqli) {
    return $mysqli->query("SELECT * FROM cash_boxes ORDER BY id DESC");
}

function get_bank_accounts($mysqli) {
    return $mysqli->query("SELECT * FROM bank_accounts ORDER BY id DESC");
}

function get_customers($mysqli) {
    return $mysqli->query("SELECT id, name FROM customers WHERE is_active=1 ORDER BY name");
}

function get_companies($mysqli) {
    return $mysqli->query("SELECT id, name FROM companies WHERE is_active=1 ORDER BY name");
}

function get_currencies($mysqli) {
    return $mysqli->query("SELECT id, name, code, symbol FROM currencies ORDER BY id");
}
?>