<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0; margin: 5px auto; max-width: 1200px;">
    <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-users" style="margin-left: 8px;"></i>
                إدارة العملاء
            </h2>
            <?php if ($auth->checkPermission('customers', 'create')): ?>
                <a href="customers.php?action=create" class="btn" 
                   style="padding: 8px 16px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                   onmouseover="this.style.background='#27ae60'"
                   onmouseout="this.style.background='#2ecc71'">
                    <i class="fas fa-user-plus" style="margin-left: 8px;"></i>
                    إضافة عميل جديد
                </a>
            <?php endif; ?>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <!-- شريط البحث والإحصائيات -->
        <div style="padding: 20px; border-bottom: 1px solid #ecf0f1;">
            <!-- شريط البحث -->
            <form method="GET" action="" style="margin-bottom: 10px;">
                <div style="display: flex; gap: 10px;">
                    <div style="position: relative; flex: 1;">
                        <input type="text" name="search" class="form-control" 
                               placeholder="ابحث باسم العميل أو رقم الهاتف..." 
                               value="<?php echo htmlspecialchars($search); ?>"
                               style="width: 100%; padding: 10px 12px 10px 40px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;">
                        <i class="fas fa-search" style="position: absolute; left: 12px; top: 50%; transform: translateY(-50%); color: #7f8c8d;"></i>
                    </div>
                    <button type="submit" class="btn" 
                            style="padding: 8px 20px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center;">
                        <i class="fas fa-search" style="margin-left: 8px;"></i>
                        بحث
                    </button>
                    <?php if (!empty($search)): ?>
                        <a href="customers.php" class="btn" 
                           style="padding: 8px 16px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center;">
                            <i class="fas fa-times" style="margin-left: 8px;"></i>
                            إلغاء البحث
                        </a>
                    <?php endif; ?>
                </div>
            </form>

            <!-- الإحصائيات -->
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px;">
                <div style="background: #e8f6f3; padding: 15px; border-left: 4px solid #1abc9c;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">إجمالي العملاء</div>
                    <div style="font-size: 24px; font-weight: bold; color: #16a085;"><?php echo number_format($totalCustomers ?? 0); ?></div>
                </div>
                <div style="background: #fef9e7; padding: 15px; border-left: 4px solid #f1c40f;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">عملاء ذو رصيد</div>
                    <div style="font-size: 24px; font-weight: bold; color: #f39c12;"><?php echo number_format($positiveBalanceCount ?? 0); ?></div>
                </div>
                <div style="background: #fdedec; padding: 15px; border-left: 4px solid #e74c3c;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">عملاء مدينين</div>
                    <div style="font-size: 24px; font-weight: bold; color: #c0392b;"><?php echo number_format($negativeBalanceCount ?? 0); ?></div>
                </div>
            </div>
        </div>

        <!-- جدول العملاء -->
        <div style="overflow-x: auto;">
            <table class="table" style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr style="background: #f8f9fa;">
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">#</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">اسم العميل</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">رقم الهاتف</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">العنوان</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">الرصيد الحالي</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">تاريخ الإضافة</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($customers)): ?>
                        <tr>
                            <td colspan="7" style="padding: 40px; text-align: center; color: #7f8c8d; font-size: 16px;">
                                <i class="fas fa-users" style="font-size: 48px; color: #ecf0f1; margin-bottom: 15px; display: block;"></i>
                                لا توجد عملاء
                                <?php if (!empty($search)): ?>
                                    <div style="margin-top: 10px; font-size: 14px;">
                                        لم يتم العثور على نتائج لبحثك: "<?php echo htmlspecialchars($search); ?>"
                                    </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($customers as $index => $customer): ?>
                        <tr style="border-bottom: 1px solid #ecf0f1; transition: background 0.3s;" 
                            onmouseover="this.style.backgroundColor='#f8f9fa'" 
                            onmouseout="this.style.backgroundColor='white'">
                            <td style="padding: 12px; text-align: center; color: #7f8c8d; font-size: 14px;">
                                <?php echo ($page - 1) * $perPage + $index + 1; ?>
                            </td>
                            <td style="padding: 12px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <div style="display: flex; align-items: center;">
                                    <div style="width: 8px; height: 8px; background: <?php echo $customer['current_balance'] >= 0 ? '#27ae60' : '#e74c3c'; ?>; 
                                                 border-radius: 50%; margin-left: 8px;"></div>
                                    <?php echo htmlspecialchars($customer['name']); ?>
                                </div>
                            </td>
                            <td style="padding: 12px; color: #34495e; font-size: 14px;">
                                <?php if (!empty($customer['phone'])): ?>
                                    <div style="display: flex; align-items: center;">
                                        <i class="fas fa-phone" style="margin-left: 8px; color: #7f8c8d; font-size: 12px;"></i>
                                        <?php echo htmlspecialchars($customer['phone']); ?>
                                    </div>
                                <?php else: ?>
                                    <span style="color: #bdc3c7;">-</span>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 12px; color: #34495e; font-size: 14px; max-width: 200px; overflow: hidden; text-overflow: ellipsis;">
                                <?php echo !empty($customer['address']) ? htmlspecialchars($customer['address']) : '<span style="color: #bdc3c7;">-</span>'; ?>
                            </td>
                            <td style="padding: 12px; font-weight: 600; font-size: 14px; text-align: left;">
                                <span style="color: <?php echo $customer['current_balance'] >= 0 ? '#27ae60' : '#e74c3c'; ?>;">
                                    <?php echo number_format($customer['current_balance'], 2); ?> 
                                    <span style="font-size: 12px; color: #7f8c8d;"><?php echo $defaultCurrencySymbol ?? '¥'; ?></span>
                                </span>
                                <?php if ($customer['current_balance'] != 0): ?>
                                    <div style="font-size: 11px; color: #95a5a6; margin-top: 3px;">
                                        <?php echo $customer['current_balance'] > 0 ? 'مدين' : 'دائن'; ?>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 12px; color: #7f8c8d; font-size: 13px;">
                                <div style="display: flex; align-items: center;">
                                    <i class="far fa-calendar" style="margin-left: 8px; color: #95a5a6;"></i>
                                    <?php echo date('Y-m-d', strtotime($customer['created_at'])); ?>
                                </div>
                                <div style="font-size: 11px; color: #bdc3c7; margin-top: 3px;">
                                    <?php echo date('H:i', strtotime($customer['created_at'])); ?>
                                </div>
                            </td>
                            <td style="padding: 12px;">
                                <div style="display: flex; gap: 5px;">
                                    <?php if ($auth->checkPermission('customers', 'update')): ?>
                                        <a href="customers.php?action=edit&id=<?php echo $customer['id']; ?>" 
                                           class="btn" 
                                           style="padding: 6px 12px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                                           onmouseover="this.style.background='#2980b9'"
                                           onmouseout="this.style.background='#3498db'">
                                            <i class="fas fa-edit" style="margin-left: 5px; font-size: 11px;"></i>
                                            تعديل
                                        </a>
                                    <?php endif; ?>
                                    <?php if ($auth->checkPermission('customers', 'delete')): ?>
                                        <a href="customers.php?action=delete&id=<?php echo $customer['id']; ?>" 
                                           class="btn" 
                                           style="padding: 6px 12px; background: #e74c3c; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                                           onmouseover="this.style.background='#c0392b'"
                                           onmouseout="this.style.background='#e74c3c'"
                                           onclick="return confirm('هل أنت متأكد من حذف هذا العميل؟')">
                                            <i class="fas fa-trash" style="margin-left: 5px; font-size: 11px;"></i>
                                            حذف
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- الترويج والتذييل -->
        <div style="padding: 20px; border-top: 1px solid #ecf0f1; background: #f8f9fa;">
            <?php if ($totalPages > 1): ?>
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 13px; color: #7f8c8d;">
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    عرض <?php echo min(($page - 1) * $perPage + 1, $totalCustomers ?? 0); ?> - 
                    <?php echo min($page * $perPage, $totalCustomers ?? 0); ?> من أصل 
                    <?php echo number_format($totalCustomers ?? 0); ?> عميل
                </div>
                <div style="display: flex; gap: 5px;">
                    <?php if ($page > 1): ?>
                        <a href="customers.php?page=<?php echo $page - 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" 
                           class="btn" 
                           style="padding: 6px 12px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center;">
                            <i class="fas fa-chevron-right" style="margin-left: 5px;"></i>
                            السابق
                        </a>
                    <?php endif; ?>
                    
                    <?php 
                    $startPage = max(1, $page - 2);
                    $endPage = min($totalPages, $page + 2);
                    ?>
                    
                    <?php for ($i = $startPage; $i <= $endPage; $i++): ?>
                        <a href="customers.php?page=<?php echo $i; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" 
                           class="btn" 
                           style="padding: 6px 12px; background: <?php echo $i == $page ? '#2c3e50' : '#95a5a6'; ?>; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; min-width: 32px; justify-content: center;">
                            <?php echo $i; ?>
                        </a>
                    <?php endfor; ?>
                    
                    <?php if ($page < $totalPages): ?>
                        <a href="customers.php?page=<?php echo $page + 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" 
                           class="btn" 
                           style="padding: 6px 12px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center;">
                            التالي
                            <i class="fas fa-chevron-left" style="margin-right: 5px;"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <?php else: ?>
                <div style="text-align: center; color: #7f8c8d; font-size: 13px;">
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    إجمالي العملاء: <?php echo number_format($totalCustomers ?? 0); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
    /* تنسيقات إضافية */
    .form-control:focus {
        outline: none;
        border-color: #3498db;
        box-shadow: 0 0 0 2px rgba(52,152,219,0.2);
    }
    
    .table tbody tr {
        transition: background-color 0.2s ease;
    }
    
    /* تخصيص شريط التمرير */
    ::-webkit-scrollbar {
        width: 8px;
        height: 8px;
    }
    
    ::-webkit-scrollbar-track {
        background: #f1f1f1;
    }
    
    ::-webkit-scrollbar-thumb {
        background: #bdc3c7;
    }
    
    ::-webkit-scrollbar-thumb:hover {
        background: #95a5a6;
    }
</style>

<script>
// وظيفة للبحث السريع (يمكن إضافتها لاحقًا)
function quickSearch() {
    // يمكن إضافة بحث Ajax هنا
}

// تأكيد الحذف مع رسالة مخصصة
function confirmDelete(customerName) {
    return confirm(`هل أنت متأكد من حذف العميل "${customerName}"؟\n\nملاحظة: سيتم حذف جميع البيانات المرتبطة بهذا العميل.`);
}

// إضافة active class للصف عند النقر عليه
document.addEventListener('DOMContentLoaded', function() {
    const rows = document.querySelectorAll('tbody tr');
    rows.forEach(row => {
        row.addEventListener('click', function(e) {
            // منع التنشيط عند النقر على الروابط أو الأزرار
            if (!e.target.closest('a')) {
                rows.forEach(r => r.classList.remove('active'));
                this.classList.add('active');
            }
        });
    });
});
</script>

<?php
include 'views/layout/footer.php';
?>