<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0; margin: 5px auto; max-width: 1200px;">
    <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-coins" style="margin-left: 8px;"></i>
                إدارة العملات
            </h2>
            <?php if ($auth->checkPermission('currencies', 'create')): ?>
                <a href="currencies.php?action=create" class="btn" 
                   style="padding: 8px 16px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                   onmouseover="this.style.background='#27ae60'"
                   onmouseout="this.style.background='#2ecc71'">
                    <i class="fas fa-plus" style="margin-left: 8px;"></i>
                    إضافة عملة جديدة
                </a>
            <?php endif; ?>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <!-- شريط البحث والإحصائيات -->
        <div style="padding: 20px; border-bottom: 1px solid #ecf0f1;">
            <!-- شريط البحث -->
            <form method="GET" action="" style="margin-bottom: 10px;">
                <div style="display: flex; gap: 10px;">
                    <div style="position: relative; flex: 1;">
                        <input type="text" name="search" class="form-control" 
                               placeholder="ابحث باسم العملة أو رمزها..." 
                               value="<?php echo htmlspecialchars($search); ?>"
                               style="width: 100%; padding: 10px 12px 10px 40px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;">
                        <i class="fas fa-search" style="position: absolute; left: 12px; top: 50%; transform: translateY(-50%); color: #7f8c8d;"></i>
                    </div>
                    <button type="submit" class="btn" 
                            style="padding: 8px 20px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center;">
                        <i class="fas fa-search" style="margin-left: 8px;"></i>
                        بحث
                    </button>
                    <?php if (!empty($search)): ?>
                        <a href="currencies.php" class="btn" 
                           style="padding: 8px 16px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center;">
                            <i class="fas fa-times" style="margin-left: 8px;"></i>
                            إلغاء البحث
                        </a>
                    <?php endif; ?>
                </div>
            </form>

            <!-- الإحصائيات -->
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px;">
                <div style="background: #e8f6f3; padding: 15px; border-left: 4px solid #1abc9c;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">إجمالي العملات</div>
                    <div style="font-size: 24px; font-weight: bold; color: #16a085;"><?php echo number_format($totalCurrencies ?? 0); ?></div>
                </div>
                <div style="background: #fef9e7; padding: 15px; border-left: 4px solid #f1c40f;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">العملة الافتراضية</div>
                    <div style="font-size: 24px; font-weight: bold; color: #f39c12;">
                        <?php 
                        $defaultCurrency = array_filter($currencies ?? [], function($curr) { 
                            return $curr['is_default'] == 1; 
                        });
                        echo count($defaultCurrency) > 0 ? htmlspecialchars(current($defaultCurrency)['name']) : 'لا يوجد';
                        ?>
                    </div>
                </div>
                <div style="background: #fde8f1; padding: 15px; border-left: 4px solid #e84393;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">العملات الأجنبية</div>
                    <div style="font-size: 24px; font-weight: bold; color: #fd79a8;">
                        <?php 
                        $foreignCurrencies = array_filter($currencies ?? [], function($curr) { 
                            return $curr['is_default'] == 0; 
                        });
                        echo number_format(count($foreignCurrencies));
                        ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- جدول العملات -->
        <div style="overflow-x: auto;">
            <table class="table" style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr style="background: #f8f9fa;">
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">#</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">اسم العملة</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">الرمز</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">الرمز النقدي</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: left; font-weight: 600; color: #F19E2C; font-size: 14px;">سعر الصرف</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">افتراضية</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">تاريخ الإضافة</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($currencies)): ?>
                        <tr>
                            <td colspan="8" style="padding: 40px; text-align: center; color: #7f8c8d; font-size: 16px;">
                                <i class="fas fa-coins" style="font-size: 48px; color: #ecf0f1; margin-bottom: 15px; display: block;"></i>
                                لا توجد عملات
                                <?php if (!empty($search)): ?>
                                    <div style="margin-top: 10px; font-size: 14px;">
                                        لم يتم العثور على نتائج لبحثك: "<?php echo htmlspecialchars($search); ?>"
                                    </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($currencies as $index => $currency): ?>
                        <tr style="border-bottom: 1px solid #ecf0f1; transition: background 0.3s;" 
                            onmouseover="this.style.backgroundColor='#f8f9fa'" 
                            onmouseout="this.style.backgroundColor='white'">
                            <td style="padding: 12px; text-align: center; color: #7f8c8d; font-size: 14px; vertical-align: middle;">
                                <?php echo ($page - 1) * $perPage + $index + 1; ?>
                            </td>
                            <td style="padding: 12px; color: #2c3e50; font-weight: 500; font-size: 14px; vertical-align: middle;">
                                <div style="display: flex; align-items: center;">
                                    <div style="width: 8px; height: 8px; background: <?php echo $currency['is_default'] ? '#27ae60' : '#3498db'; ?>; 
                                                 border-radius: 50%; margin-left: 8px;"></div>
                                    <?php echo htmlspecialchars($currency['name']); ?>
                                </div>
                            </td>
                            <td style="padding: 12px; color: #34495e; font-size: 14px; vertical-align: middle;">
                                <div style="display: inline-block; background: #f1f2f6; padding: 4px 8px; border-radius: 3px; font-family: monospace; font-weight: 600; color: #2c3e50;">
                                    <?php echo htmlspecialchars($currency['code']); ?>
                                </div>
                            </td>
                            <td style="padding: 12px; color: #34495e; font-size: 18px; vertical-align: middle;">
                                <?php echo !empty($currency['symbol']) ? htmlspecialchars($currency['symbol']) : '<span style="color: #bdc3c7;">-</span>'; ?>
                            </td>
                            <td style="padding: 12px; text-align: left; vertical-align: middle;">
                                <div style="font-weight: 600; color: #2c3e50; font-size: 14px;">
                                    <?php echo number_format($currency['exchange_rate'], 6); ?>
                                </div>
                                <div style="font-size: 11px; color: #7f8c8d; margin-top: 3px;">
                                    مقابل العملة المحلية
                                </div>
                            </td>
                            <td style="padding: 12px; text-align: center; vertical-align: middle;">
                                <?php if ($currency['is_default']): ?>
                                    <span style="background: #d5f4e6; color: #27ae60; padding: 5px 10px; border-radius: 3px; font-size: 12px; font-weight: 600; display: inline-block;">
                                        <i class="fas fa-check" style="margin-left: 5px;"></i>
                                        افتراضية
                                    </span>
                                <?php else: ?>
                                    <span style="background: #f1f2f6; color: #7f8c8d; padding: 5px 10px; border-radius: 3px; font-size: 12px; font-weight: 600; display: inline-block;">
                                        -
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 12px; color: #7f8c8d; font-size: 13px; vertical-align: middle;">
                                <div style="display: flex; align-items: center; justify-content: flex-end;">
                                    <i class="far fa-calendar" style="margin-left: 8px; color: #95a5a6;"></i>
                                    <?php echo date('Y-m-d', strtotime($currency['created_at'])); ?>
                                </div>
                                <div style="font-size: 11px; color: #bdc3c7; margin-top: 3px; text-align: right;">
                                    <?php echo date('H:i', strtotime($currency['created_at'])); ?>
                                </div>
                            </td>
                            <td style="padding: 12px; vertical-align: middle;">
                                <div style="display: flex; gap: 5px; justify-content: center;">
                                    <?php if ($auth->checkPermission('currencies', 'update')): ?>
                                        <a href="currencies.php?action=edit&id=<?php echo $currency['id']; ?>" 
                                           class="btn" 
                                           style="padding: 6px 12px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                                           onmouseover="this.style.background='#2980b9'"
                                           onmouseout="this.style.background='#3498db'">
                                            <i class="fas fa-edit" style="margin-left: 5px; font-size: 11px;"></i>
                                            تعديل
                                        </a>
                                    <?php endif; ?>
                                    <?php if ($auth->checkPermission('currencies', 'delete') && !$currency['is_default']): ?>
                                        <a href="currencies.php?action=delete&id=<?php echo $currency['id']; ?>" 
                                           class="btn" 
                                           style="padding: 6px 12px; background: #e74c3c; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                                           onmouseover="this.style.background='#c0392b'"
                                           onmouseout="this.style.background='#e74c3c'"
                                           onclick="return confirmDelete('<?php echo htmlspecialchars(addslashes($currency['name'])); ?>', <?php echo $currency['is_default'] ? 'true' : 'false'; ?>)">
                                            <i class="fas fa-trash" style="margin-left: 5px; font-size: 11px;"></i>
                                            حذف
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- الترويج والتذييل -->
        <div style="padding: 20px; border-top: 1px solid #ecf0f1; background: #f8f9fa;">
            <?php if ($totalPages > 1): ?>
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 13px; color: #7f8c8d;">
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    عرض <?php echo min(($page - 1) * $perPage + 1, $totalCurrencies ?? 0); ?> - 
                    <?php echo min($page * $perPage, $totalCurrencies ?? 0); ?> من أصل 
                    <?php echo number_format($totalCurrencies ?? 0); ?> عملة
                </div>
                <div style="display: flex; gap: 5px;">
                    <?php if ($page > 1): ?>
                        <a href="currencies.php?page=<?php echo $page - 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" 
                           class="btn" 
                           style="padding: 6px 12px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center;">
                            <i class="fas fa-chevron-right" style="margin-left: 5px;"></i>
                            السابق
                        </a>
                    <?php endif; ?>
                    
                    <?php 
                    $startPage = max(1, $page - 2);
                    $endPage = min($totalPages, $page + 2);
                    ?>
                    
                    <?php for ($i = $startPage; $i <= $endPage; $i++): ?>
                        <a href="currencies.php?page=<?php echo $i; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" 
                           class="btn" 
                           style="padding: 6px 12px; background: <?php echo $i == $page ? '#2c3e50' : '#95a5a6'; ?>; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; min-width: 32px; justify-content: center;">
                            <?php echo $i; ?>
                        </a>
                    <?php endfor; ?>
                    
                    <?php if ($page < $totalPages): ?>
                        <a href="currencies.php?page=<?php echo $page + 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" 
                           class="btn" 
                           style="padding: 6px 12px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center;">
                            التالي
                            <i class="fas fa-chevron-left" style="margin-right: 5px;"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <?php else: ?>
                <div style="text-align: center; color: #7f8c8d; font-size: 13px;">
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    إجمالي العملات: <?php echo number_format($totalCurrencies ?? 0); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
    /* تنسيقات إضافية */
    .form-control:focus {
        outline: none;
        border-color: #3498db;
        box-shadow: 0 0 0 2px rgba(52,152,219,0.2);
    }
    
    .table tbody tr {
        transition: background-color 0.2s ease;
    }
    
    /* تخصيص شريط التمرير */
    ::-webkit-scrollbar {
        width: 8px;
        height: 8px;
    }
    
    ::-webkit-scrollbar-track {
        background: #f1f1f1;
    }
    
    ::-webkit-scrollbar-thumb {
        background: #bdc3c7;
    }
    
    ::-webkit-scrollbar-thumb:hover {
        background: #95a5a6;
    }
</style>

<script>
// وظيفة للبحث السريع (يمكن إضافتها لاحقًا)
function quickSearch() {
    // يمكن إضافة بحث Ajax هنا
}

// تأكيد الحذف مع رسالة مخصصة
function confirmDelete(currencyName, isDefault) {
    if (isDefault) {
        alert('لا يمكن حذف العملة الافتراضية!');
        return false;
    }
    
    return confirm(`هل أنت متأكد من حذف العملة "${currencyName}"؟\n\nملاحظة: سيتم حذف جميع البيانات المرتبطة بهذه العملة.`);
}

// إضافة active class للصف عند النقر عليه
document.addEventListener('DOMContentLoaded', function() {
    const rows = document.querySelectorAll('tbody tr');
    rows.forEach(row => {
        row.addEventListener('click', function(e) {
            // منع التنشيط عند النقر على الروابط أو الأزرار
            if (!e.target.closest('a')) {
                rows.forEach(r => r.classList.remove('active'));
                this.classList.add('active');
            }
        });
    });
});
</script>

<?php
include 'views/layout/footer.php';
?>