<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0;padding: 8px;  margin: 5px auto; max-width: 1200px;">
 <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;  position: sticky; top: 0;
z-index: 1100;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-user-edit" style="margin-left: 8px;"></i>
                تعديل بيانات المستخدم
            </h2>
            <div style="font-size: 12px; opacity: 0.8;">
                <span class="badge" style="background: #3498db; padding: 4px 8px; border-radius: 0;">تعديل بيانات</span>
            </div>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <?php if (!empty($error)): ?>
        <div class="alert alert-danger" style="margin: 0; border-radius: 0; border: none; border-bottom: 1px solid #e74c3c; background: #ffe6e6; padding: 12px 20px; display: flex; align-items: center;">
            <i class="fas fa-exclamation-circle" style="margin-left: 10px; color: #e74c3c;"></i>
            <span><?php echo htmlspecialchars($error); ?></span>
        </div>
        <?php endif; ?>

        <!-- Loader Overlay -->
        <div id="loadingOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255,255,255,0.9); z-index: 9999; justify-content: center; align-items: center; flex-direction: column;">
            <div class="loader" style="width: 50px; height: 50px; border: 5px solid #f3f3f3; border-top: 5px solid #3498db; border-radius: 50%; animation: spin 1s linear infinite; margin-bottom: 20px;"></div>
            <div style="color: #2c3e50; font-size: 16px; font-weight: 500;">جاري تحديث بيانات المستخدم...</div>
            <div style="color: #7f8c8d; font-size: 14px; margin-top: 10px;">يرجى الانتظار</div>
        </div>

        <form method="POST" action="" id="userForm" onsubmit="showLoader()">
            <input type="hidden" name="id" value="<?php echo $user['id']; ?>">
            
            <div style="padding: 25px;">
                <!-- المعلومات الأساسية -->
                <div class="form-section" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #ecf0f1;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #3498db; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-user-circle" style="margin-left: 8px; color: #3498db;"></i>
                            المعلومات الأساسية
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="username" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> اسم المستخدم
                            </label>
                            <input type="text" class="form-control" id="username" name="username" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; transition: border-color 0.3s;"
                                   onfocus="this.style.borderColor='#3498db'; this.style.boxShadow='0 0 0 2px rgba(52,152,219,0.2)';"
                                   onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none';"
                                   value="<?php echo htmlspecialchars($user['username']); ?>"
                                   placeholder="أدخل اسم المستخدم">
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> اسم المستخدم الذي سيتم استخدامه لتسجيل الدخول
                            </small>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="email" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> البريد الإلكتروني
                            </label>
                            <input type="email" class="form-control" id="email" name="email" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; direction: ltr;"
                                   value="<?php echo htmlspecialchars($user['email']); ?>"
                                   placeholder="example@domain.com">
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-envelope"></i> البريد الإلكتروني الرسمي للمستخدم
                            </small>
                        </div>
                    </div>

                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="password" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                كلمة المرور الجديدة
                            </label>
                            <input type="password" class="form-control" id="password" name="password"
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                   placeholder="أدخل كلمة المرور الجديدة">
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-key"></i> اترك الحقل فارغاً إذا لم ترغب في تغيير كلمة المرور
                            </small>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="role_id" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> الدور
                            </label>
                            <select class="form-control" id="role_id" name="role_id" required
                                    style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; background: white; cursor: pointer;">
                                <option value="">اختر الدور</option>
                                <?php foreach ($roles as $role): ?>
                                    <option value="<?php echo $role['id']; ?>" 
                                            <?php echo ($user['role_id'] == $role['id']) ? 'selected' : ''; ?>
                                            style="padding: 5px;">
                                        <?php echo htmlspecialchars($role['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-user-tag"></i> حدد صلاحيات المستخدم في النظام
                            </small>
                        </div>
                    </div>
                </div>

                <!-- معلومات إضافية -->
                <div class="form-section" style="margin-bottom: 30px; padding: 15px; background: #f8f9fa; border-left: 4px solid #3498db;">
                    <div style="display: flex; align-items: center; margin-bottom: 10px;">
                        <i class="fas fa-info-circle" style="margin-left: 8px; color: #3498db;"></i>
                        <h4 style="margin: 0; font-size: 14px; color: #2c3e50; font-weight: 600;">
                            معلومات إضافية:
                        </h4>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 10px; font-size: 12px;">
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #7f8c8d; margin-bottom: 3px;">تاريخ الإنشاء</div>
                            <div style="color: #2c3e50; font-weight: 500;">
                                <?php echo date('Y-m-d H:i', strtotime($user['created_at'])); ?>
                            </div>
                        </div>
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #7f8c8d; margin-bottom: 3px;">آخر تحديث</div>
                            <div style="color: #2c3e50; font-weight: 500;">
                                <?php echo !empty($user['updated_at']) ? date('Y-m-d H:i', strtotime($user['updated_at'])) : 'لم يتم التحديث'; ?>
                            </div>
                        </div>
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #7f8c8d; margin-bottom: 3px;">الحالة</div>
                            <div style="color: <?php echo $user['is_active'] ? '#2ecc71' : '#e74c3c'; ?>; font-weight: 600;">
                                <?php echo $user['is_active'] ? 'نشط' : 'غير نشط'; ?>
                            </div>
                        </div>
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #7f8c8d; margin-bottom: 3px;">آخر تسجيل دخول</div>
                            <div style="color: #2c3e50; font-weight: 500;">
                                <?php echo !empty($user['last_login']) ? date('Y-m-d H:i', strtotime($user['last_login'])) : 'غير متاح'; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- شرح الأدوار -->
                <div class="form-section" style="margin-bottom: 30px; padding: 15px; background: #f8f9fa; border-left: 4px solid #3498db;">
                    <div style="display: flex; align-items: center; margin-bottom: 10px;">
                        <i class="fas fa-user-shield" style="margin-left: 8px; color: #3498db;"></i>
                        <h4 style="margin: 0; font-size: 14px; color: #2c3e50; font-weight: 600;">
                            شرح الأدوار المتاحة:
                        </h4>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 10px; font-size: 12px;">
                        <?php foreach ($roles as $role): ?>
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #3498db; font-weight: bold; margin-bottom: 5px;">
                                <?php echo htmlspecialchars($role['name']); ?>
                            </div>
                            <div style="color: #7f8c8d; font-size: 11px;">
                                <?php 
                                $descriptions = [
                                    'admin' => 'صلاحيات كاملة على النظام',
                                    'manager' => 'إدارة المستخدمين والمحتوى',
                                    'editor' => 'تحرير المحتوى فقط',
                                    'viewer' => 'عرض المحتوى دون تعديل'
                                ];
                                echo $descriptions[strtolower($role['name'])] ?? 'صلاحيات محددة';
                                ?>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Footer Buttons -->
            <div style="background: #f8f9fa; padding: 15px 25px; border-top: 1px solid #ecf0f1; display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 12px; color: #7f8c8d;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 5px;"></i>
                    الحقول المميزة بـ <span style="color: #e74c3c;">*</span> إجبارية
                </div>
                
                <div style="display: flex; gap: 10px;">
                    <a href="users.php" class="btn" 
                       style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                       onmouseover="this.style.background='#7f8c8d'"
                       onmouseout="this.style.background='#95a5a6'">
                        <i class="fas fa-times" style="margin-left: 8px;"></i>
                        إلغاء
                    </a>
                    <button type="submit" class="btn" 
                            style="padding: 8px 25px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                            onmouseover="this.style.background='#27ae60'"
                            onmouseout="this.style.background='#2ecc71'">
                        <i class="fas fa-save" style="margin-left: 8px;"></i>
                        تحديث البيانات
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .form-control:focus, select:focus {
        outline: none;
    }
    
    .alert-error {
        display: none;
    }
    
    /* Additional styling for better visual */
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-label {
        display: block;
        margin-bottom: 8px;
        color: #2c3e50;
        font-weight: 500;
        font-size: 14px;
    }
    
    select {
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='%232c3e50' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3e%3cpolyline points='6 9 12 15 18 9'%3e%3c/polyline%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 10px center;
        background-size: 15px;
        padding-right: 35px !important;
    }
</style>

<script>
function showLoader() {
    // Validate form first
    if (validateForm()) {
        document.getElementById('loadingOverlay').style.display = 'flex';
        return true;
    }
    return false;
}

function validateForm() {
    const usernameField = document.getElementById('username');
    const emailField = document.getElementById('email');
    const roleField = document.getElementById('role_id');
    let isValid = true;
    
    // Reset styles
    usernameField.style.borderColor = '#bdc3c7';
    usernameField.style.boxShadow = 'none';
    emailField.style.borderColor = '#bdc3c7';
    emailField.style.boxShadow = 'none';
    roleField.style.borderColor = '#bdc3c7';
    roleField.style.boxShadow = 'none';
    
    // Validate username
    if (!usernameField.value.trim()) {
        usernameField.style.borderColor = '#e74c3c';
        usernameField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    }
    
    // Validate email
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailField.value.trim()) {
        emailField.style.borderColor = '#e74c3c';
        emailField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    } else if (!emailRegex.test(emailField.value.trim())) {
        emailField.style.borderColor = '#e74c3c';
        emailField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        alert('الرجاء إدخال بريد إلكتروني صالح');
        isValid = false;
    }
    
    // Validate role
    if (!roleField.value) {
        roleField.style.borderColor = '#e74c3c';
        roleField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    }
    
    // Validate password if provided
    const passwordField = document.getElementById('password');
    if (passwordField.value.trim()) {
        if (passwordField.value.length < 6) {
            passwordField.style.borderColor = '#e74c3c';
            passwordField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
            alert('كلمة المرور يجب أن تكون على الأقل 6 أحرف');
            isValid = false;
        }
    }
    
    if (!isValid) {
        alert('الرجاء تعبئة الحقول الإجبارية بشكل صحيح');
        return false;
    }
    
    return true;
}

// Add input event listeners to clear error styles
document.querySelectorAll('.form-control').forEach(field => {
    field.addEventListener('input', function() {
        if (this.value.trim()) {
            this.style.borderColor = '#bdc3c7';
            this.style.boxShadow = 'none';
        }
    });
});

// Clear error style on select change
document.getElementById('role_id').addEventListener('change', function() {
    if (this.value) {
        this.style.borderColor = '#bdc3c7';
        this.style.boxShadow = 'none';
    }
});

// Show loader if page is taking time to submit (fallback)
setTimeout(() => {
    const loader = document.getElementById('loadingOverlay');
    if (loader && loader.style.display === 'flex') {
        const messages = loader.querySelectorAll('div');
        if (messages.length >= 2) {
            messages[1].textContent = 'لا يزال جاري معالجة البيانات...';
            messages[2].textContent = 'قد تستغرق العملية وقتاً أطول من المتوقع';
        }
    }
}, 5000);
</script>

<?php
include 'views/layout/footer.php';
?>