<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0;padding: 8px;  margin: 5px auto; max-width: 1200px;">
 <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;  position: sticky; top: 0;
z-index: 1100;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-cubes" style="margin-left: 8px;"></i>
                إدارة الأصناف
            </h2>
            <?php if ($auth->checkPermission('items', 'create')): ?>
                <a href="items.php?action=create" class="btn" 
                   style="padding: 8px 16px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                   onmouseover="this.style.background='#27ae60'"
                   onmouseout="this.style.background='#2ecc71'">
                    <i class="fas fa-plus" style="margin-left: 8px;"></i>
                    إضافة صنف جديد
                </a>
            <?php endif; ?>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <!-- شريط البحث والإحصائيات -->
        <div style="padding: 20px; border-bottom: 1px solid #ecf0f1;">
            <!-- شريط البحث -->
            <form method="GET" action="" style="margin-bottom: 10px;">
                <div style="display: flex; gap: 10px;">
                    <div style="position: relative; flex: 1;">
                        <input type="text" name="search" class="form-control" 
                               placeholder="ابحث باسم الصنف أو الموديل..." 
                               value="<?php echo htmlspecialchars($search); ?>"
                               style="width: 100%; padding: 10px 12px 10px 40px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;">
                        <i class="fas fa-search" style="position: absolute; left: 12px; top: 50%; transform: translateY(-50%); color: #7f8c8d;"></i>
                    </div>
                    <button type="submit" class="btn" 
                            style="padding: 8px 20px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center;">
                        <i class="fas fa-search" style="margin-left: 8px;"></i>
                        بحث
                    </button>
                    <?php if (!empty($search)): ?>
                        <a href="items.php" class="btn" 
                           style="padding: 8px 16px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center;">
                            <i class="fas fa-times" style="margin-left: 8px;"></i>
                            إلغاء البحث
                        </a>
                    <?php endif; ?>
                </div>
            </form>

            <!-- الإحصائيات -->
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px;">
                <div style="background: #e8f6f3; padding: 15px; border-left: 4px solid #1abc9c;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">إجمالي الأصناف</div>
                    <div style="font-size: 24px; font-weight: bold; color: #16a085;"><?php echo number_format($totalItems ?? 0); ?></div>
                </div>
                <div style="background: #fef9e7; padding: 15px; border-left: 4px solid #f1c40f;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">أصناف متوفرة</div>
                    <div style="font-size: 24px; font-weight: bold; color: #f39c12;"><?php echo number_format($inStockCount ?? 0); ?></div>
                </div>
                <div style="background: #fdedec; padding: 15px; border-left: 4px solid #e74c3c;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">أصناف نفذت</div>
                    <div style="font-size: 24px; font-weight: bold; color: #c0392b;"><?php echo number_format($outOfStockCount ?? 0); ?></div>
                </div>
                <div style="background: #e8f4fd; padding: 15px; border-left: 4px solid #3498db;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">قيمة المخزون</div>
                    <div style="font-size: 24px; font-weight: bold; color: #2980b9;">
                        <?php echo number_format($totalStockValue ?? 0, 2); ?> 
                        <span style="font-size: 14px;"><?php echo $defaultCurrencySymbol ?? '¥'; ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- جدول الأصناف -->
        <div style="overflow-x: auto;">
            <table class="table" style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr style="background: #f8f9fa;">
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">#</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">الصورة</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">اسم الصنف</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">الموديل</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: left; font-weight: 600; color: #F19E2C; font-size: 14px;">السعر</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: left; font-weight: 600; color: #F19E2C; font-size: 14px;">المخزون</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">الوحدة</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">الشركة</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($items)): ?>
                        <tr>
                            <td colspan="9" style="padding: 40px; text-align: center; color: #7f8c8d; font-size: 16px;">
                                <i class="fas fa-cubes" style="font-size: 48px; color: #ecf0f1; margin-bottom: 15px; display: block;"></i>
                                لا توجد أصناف
                                <?php if (!empty($search)): ?>
                                    <div style="margin-top: 10px; font-size: 14px;">
                                        لم يتم العثور على نتائج لبحثك: "<?php echo htmlspecialchars($search); ?>"
                                    </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($items as $index => $item): ?>
                        <tr style="border-bottom: 1px solid #ecf0f1; transition: background 0.3s;" 
                            onmouseover="this.style.backgroundColor='#f8f9fa'" 
                            onmouseout="this.style.backgroundColor='white'">
                            <td style="padding: 12px; text-align: center; color: #7f8c8d; font-size: 14px; vertical-align: middle;">
                                <?php echo ($page - 1) * $perPage + $index + 1; ?>
                            </td>
                            <td style="padding: 12px; text-align: center; vertical-align: middle;">
                                <?php if (!empty($item['image'])): ?>
                                    <div style="position: relative;">
                                        <img src="uploads/items/<?php echo htmlspecialchars($item['image']); ?>" 
                                             alt="<?php echo htmlspecialchars($item['name']); ?>" 
                                             style="width: 50px; height: 50px; object-fit: cover; border: 1px solid #ecf0f1;"
                                             onmouseover="showImagePreview(this.src, '<?php echo htmlspecialchars($item['name']); ?>')"
                                             onmouseout="hideImagePreview()">
                                        <div style="position: absolute; bottom: -5px; right: -5px; background: #3498db; color: white; width: 20px; height: 20px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 10px;">
                                            <i class="fas fa-image"></i>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div style="width: 50px; height: 50px; background: #f8f9fa; display: flex; align-items: center; justify-content: center; border: 1px dashed #bdc3c7; position: relative;">
                                        <i class="far fa-image" style="color: #bdc3c7; font-size: 20px;"></i>
                                        <div style="position: absolute; bottom: -5px; right: -5px; background: #95a5a6; color: white; width: 20px; height: 20px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 10px;">
                                            <i class="fas fa-times"></i>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 12px; color: #2c3e50; font-weight: 500; font-size: 14px; vertical-align: middle;">
                                <div style="display: flex; align-items: center;">
                                    <div style="width: 8px; height: 8px; background: <?php echo $item['current_stock'] > 0 ? '#27ae60' : '#e74c3c'; ?>; 
                                                 border-radius: 50%; margin-left: 8px;"></div>
                                    <?php echo htmlspecialchars($item['name']); ?>
                                    <?php if (!empty($item['specifications'])): ?>
                                        <i class="fas fa-info-circle" style="margin-right: 5px; color: #3498db; cursor: help;" 
                                           title="<?php echo htmlspecialchars($item['specifications']); ?>"></i>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td style="padding: 12px; color: #34495e; font-size: 14px; vertical-align: middle;">
                                <?php echo !empty($item['model']) ? htmlspecialchars($item['model']) : '<span style="color: #bdc3c7;">-</span>'; ?>
                            </td>
                            <td style="padding: 12px; text-align: left; vertical-align: middle;">
                                <div style="font-weight: 600; color: #2c3e50; font-size: 14px;">
                                    <?php echo number_format($item['default_price'], 2); ?> 
                                    <span style="font-size: 12px; color: #7f8c8d;"><?php echo $defaultCurrencySymbol ?? '¥'; ?></span>
                                </div>
                            </td>
                            <td style="padding: 12px; text-align: left; vertical-align: middle;">
                                <div style="display: flex; flex-direction: column;">
                                    <span style="font-weight: 600; color: <?php echo $item['current_stock'] > 0 ? '#27ae60' : '#e74c3c'; ?>; font-size: 14px;">
                                        <?php echo number_format($item['current_stock'], 2); ?>
                                    </span>
                                    <?php if ($item['current_stock'] <= 0): ?>
                                        <span style="font-size: 11px; color: #e74c3c; margin-top: 3px;">
                                            <i class="fas fa-exclamation-triangle"></i> نفذ من المخزون
                                        </span>
                                    <?php elseif ($item['current_stock'] < 10): ?>
                                        <span style="font-size: 11px; color: #f39c12; margin-top: 3px;">
                                            <i class="fas fa-exclamation-circle"></i> مخزون منخفض
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td style="padding: 12px; color: #34495e; font-size: 14px; vertical-align: middle;">
                                <div style="display: flex; align-items: center; justify-content: flex-end;">
                                    <span style="background: #e8f4fd; padding: 3px 8px; border-radius: 2px; font-size: 12px; color: #3498db;">
                                        <?php echo htmlspecialchars($item['unit_name']); ?>
                                    </span>
                                </div>
                            </td>
                            <td style="padding: 12px; color: #34495e; font-size: 14px; vertical-align: middle;">
                                <div style="display: flex; align-items: center; justify-content: flex-end;">
                                    <?php if (!empty($item['company_name'])): ?>
                                        <i class="fas fa-building" style="margin-left: 5px; color: #95a5a6; font-size: 12px;"></i>
                                        <?php echo htmlspecialchars($item['company_name']); ?>
                                    <?php else: ?>
                                        <span style="color: #bdc3c7;">-</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td style="padding: 12px; vertical-align: middle;">
                                <div style="display: flex; gap: 5px; justify-content: center;">
                                    <?php if ($auth->checkPermission('items', 'update')): ?>
                                        <a href="items.php?action=edit&id=<?php echo $item['id']; ?>" 
                                           class="btn" 
                                           style="padding: 6px 12px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                                           onmouseover="this.style.background='#2980b9'"
                                           onmouseout="this.style.background='#3498db'">
                                            <i class="fas fa-edit" style="margin-left: 5px; font-size: 11px;"></i>
                                            تعديل
                                        </a>
                                    <?php endif; ?>
                                    <?php if ($auth->checkPermission('items', 'delete')): ?>
                                        <a href="items.php?action=delete&id=<?php echo $item['id']; ?>" 
                                           class="btn" 
                                           style="padding: 6px 12px; background: #e74c3c; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                                           onmouseover="this.style.background='#c0392b'"
                                           onmouseout="this.style.background='#e74c3c'"
                                           onclick="return confirmDelete('<?php echo htmlspecialchars(addslashes($item['name'])); ?>')">
                                            <i class="fas fa-trash" style="margin-left: 5px; font-size: 11px;"></i>
                                            حذف
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- الترويج والتذييل -->
        <div style="padding: 20px; border-top: 1px solid #ecf0f1; background: #f8f9fa;">
            <?php if ($totalPages > 1): ?>
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 13px; color: #7f8c8d;">
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    عرض <?php echo min(($page - 1) * $perPage + 1, $totalItems ?? 0); ?> - 
                    <?php echo min($page * $perPage, $totalItems ?? 0); ?> من أصل 
                    <?php echo number_format($totalItems ?? 0); ?> صنف
                </div>
                <div style="display: flex; gap: 5px;">
                    <?php if ($page > 1): ?>
                        <a href="items.php?page=<?php echo $page - 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" 
                           class="btn" 
                           style="padding: 6px 12px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center;">
                            <i class="fas fa-chevron-right" style="margin-left: 5px;"></i>
                            السابق
                        </a>
                    <?php endif; ?>
                    
                    <?php 
                    $startPage = max(1, $page - 2);
                    $endPage = min($totalPages, $page + 2);
                    ?>
                    
                    <?php for ($i = $startPage; $i <= $endPage; $i++): ?>
                        <a href="items.php?page=<?php echo $i; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" 
                           class="btn" 
                           style="padding: 6px 12px; background: <?php echo $i == $page ? '#2c3e50' : '#95a5a6'; ?>; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; min-width: 32px; justify-content: center;">
                            <?php echo $i; ?>
                        </a>
                    <?php endfor; ?>
                    
                    <?php if ($page < $totalPages): ?>
                        <a href="items.php?page=<?php echo $page + 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" 
                           class="btn" 
                           style="padding: 6px 12px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center;">
                            التالي
                            <i class="fas fa-chevron-left" style="margin-right: 5px;"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <?php else: ?>
                <div style="text-align: center; color: #7f8c8d; font-size: 13px;">
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    إجمالي الأصناف: <?php echo number_format($totalItems ?? 0); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- معاينة الصورة -->
<div id="imagePreview" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 10000; background: white; padding: 10px; border: 2px solid #3498db; box-shadow: 0 0 20px rgba(0,0,0,0.2); max-width: 400px;">
    <div id="imagePreviewContent" style="position: relative;">
        <img id="previewImage" src="" style="max-width: 100%; max-height: 300px; display: block;">
        <div id="imagePreviewTitle" style="padding: 10px; background: #3498db; color: white; text-align: center; font-size: 14px;"></div>
        <button onclick="hideImagePreview()" style="position: absolute; top: -10px; left: -10px; background: #e74c3c; color: white; border: none; width: 25px; height: 25px; border-radius: 50%; cursor: pointer; font-weight: bold;">×</button>
    </div>
</div>

<style>
    /* تنسيقات إضافية */
    .form-control:focus {
        outline: none;
        border-color: #3498db;
        box-shadow: 0 0 0 2px rgba(52,152,219,0.2);
    }
    
    .table tbody tr {
        transition: background-color 0.2s ease;
    }
    
    /* تخصيص شريط التمرير */
    ::-webkit-scrollbar {
        width: 8px;
        height: 8px;
    }
    
    ::-webkit-scrollbar-track {
        background: #f1f1f1;
    }
    
    ::-webkit-scrollbar-thumb {
        background: #bdc3c7;
    }
    
    ::-webkit-scrollbar-thumb:hover {
        background: #95a5a6;
    }
    
    /* معاينة الصورة */
    #imagePreview {
        transition: all 0.3s ease;
    }
</style>

<script>
// معاينة الصورة
function showImagePreview(imageSrc, title) {
    const preview = document.getElementById('imagePreview');
    const previewImage = document.getElementById('previewImage');
    const previewTitle = document.getElementById('imagePreviewTitle');
    
    previewImage.src = imageSrc;
    previewTitle.textContent = title;
    preview.style.display = 'block';
}

function hideImagePreview() {
    document.getElementById('imagePreview').style.display = 'none';
}

// وظيفة للبحث السريع (يمكن إضافتها لاحقًا)
function quickSearch() {
    // يمكن إضافة بحث Ajax هنا
}

// تأكيد الحذف مع رسالة مخصصة
function confirmDelete(itemName) {
    return confirm(`هل أنت متأكد من حذف الصنف "${itemName}"؟\n\nملاحظة: سيتم حذف جميع البيانات المرتبطة بهذا الصنف.`);
}

// إضافة active class للصف عند النقر عليه
document.addEventListener('DOMContentLoaded', function() {
    const rows = document.querySelectorAll('tbody tr');
    rows.forEach(row => {
        row.addEventListener('click', function(e) {
            // منع التنشيط عند النقر على الروابط أو الأزرار
            if (!e.target.closest('a') && !e.target.closest('img') && !e.target.closest('i.fa-info-circle')) {
                rows.forEach(r => r.classList.remove('active'));
                this.classList.add('active');
            }
        });
    });
    
    // إغلاق معاينة الصورة عند النقر خارجها
    document.addEventListener('click', function(e) {
        const preview = document.getElementById('imagePreview');
        if (preview.style.display === 'block' && !preview.contains(e.target) && !e.target.matches('img[onmouseover]')) {
            hideImagePreview();
        }
    });
});
</script>

<?php
include 'views/layout/footer.php';
?>