<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0;padding: 8px;  margin: 5px auto; max-width: 1200px;">
 <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;  position: sticky; top: 0;
z-index: 1100;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-ruler-combined" style="margin-left: 8px;"></i>
                تعديل وحدة القياس
            </h2>
            <div style="font-size: 12px; opacity: 0.8;">
                <span class="badge" style="background: #3498db; padding: 4px 8px; border-radius: 0;">تعديل بيانات</span>
            </div>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <?php if (!empty($error)): ?>
        <div class="alert alert-danger" style="margin: 0; border-radius: 0; border: none; border-bottom: 1px solid #e74c3c; background: #ffe6e6; padding: 12px 20px; display: flex; align-items: center;">
            <i class="fas fa-exclamation-circle" style="margin-left: 10px; color: #e74c3c;"></i>
            <span><?php echo htmlspecialchars($error); ?></span>
        </div>
        <?php endif; ?>

        <!-- Loader Overlay -->
        <div id="loadingOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255,255,255,0.9); z-index: 9999; justify-content: center; align-items: center; flex-direction: column;">
            <div class="loader" style="width: 50px; height: 50px; border: 5px solid #f3f3f3; border-top: 5px solid #3498db; border-radius: 50%; animation: spin 1s linear infinite; margin-bottom: 20px;"></div>
            <div style="color: #2c3e50; font-size: 16px; font-weight: 500;">جاري تحديث بيانات الوحدة...</div>
            <div style="color: #7f8c8d; font-size: 14px; margin-top: 10px;">يرجى الانتظار</div>
        </div>

        <form method="POST" action="" id="unitForm" onsubmit="showLoader()">
            <input type="hidden" name="id" value="<?php echo $unit['id']; ?>">
            
            <div style="padding: 25px;">
                <!-- معلومات وحدة القياس -->
                <div class="form-section" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #ecf0f1;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #3498db; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-cog" style="margin-left: 8px; color: #3498db;"></i>
                            تفاصيل وحدة القياس
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="name" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> اسم الوحدة
                            </label>
                            <input type="text" class="form-control" id="name" name="name" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; transition: border-color 0.3s;"
                                   onfocus="this.style.borderColor='#3498db'; this.style.boxShadow='0 0 0 2px rgba(52,152,219,0.2)';"
                                   onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none';"
                                   value="<?php echo htmlspecialchars($unit['name']); ?>"
                                   placeholder="أدخل اسم الوحدة">
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> الاسم الكامل لوحدة القياس (مثال: كيلوجرام)
                            </small>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="code" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> رمز الوحدة
                            </label>
                            <input type="text" class="form-control" id="code" name="code" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; text-transform: uppercase;"
                                   value="<?php echo htmlspecialchars($unit['code']); ?>"
                                   placeholder="أدخل رمز الوحدة"
                                   oninput="this.value = this.value.toUpperCase()">
                            <div style="background: #f8f9fa; padding: 8px; margin-top: 8px; border-left: 3px solid #3498db;">
                                <div style="font-size: 12px; color: #7f8c8d;">
                                    <i class="fas fa-lightbulb" style="margin-left: 5px; color: #f39c12;"></i>
                                    <strong>أمثلة:</strong> KG, CTN, PCS, L, M, CM
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="description" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                            الوصف
                        </label>
                        <textarea class="form-control" id="description" name="description" rows="3"
                                  style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; resize: vertical; min-height: 80px;"
                                  placeholder="أدخل وصفاً تفصيلياً لوحدة القياس (اختياري)..."><?php echo htmlspecialchars($unit['description']); ?></textarea>
                        <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                            <i class="fas fa-info-circle"></i> وصف تفصيلي يوضح استخدامات الوحدة ونطاقها
                        </small>
                    </div>
                </div>

                <!-- معلومات إضافية -->
                <div class="form-section" style="margin-bottom: 30px; padding: 15px; background: #f8f9fa; border-left: 4px solid #3498db;">
                    <div style="display: flex; align-items: center; margin-bottom: 10px;">
                        <i class="fas fa-info-circle" style="margin-left: 8px; color: #3498db;"></i>
                        <h4 style="margin: 0; font-size: 14px; color: #2c3e50; font-weight: 600;">
                            معلومات إضافية:
                        </h4>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 10px; font-size: 12px;">
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #7f8c8d; margin-bottom: 3px;">تاريخ الإنشاء</div>
                            <div style="color: #2c3e50; font-weight: 500;">
                                <?php echo date('Y-m-d', strtotime($unit['created_at'])); ?>
                            </div>
                        </div>
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #7f8c8d; margin-bottom: 3px;">آخر تحديث</div>
                            <div style="color: #2c3e50; font-weight: 500;">
                                <?php echo !empty($unit['updated_at']) ? date('Y-m-d', strtotime($unit['updated_at'])) : 'لم يتم التحديث'; ?>
                            </div>
                        </div>
                       
                    </div>
                </div>

                <!-- أمثلة الوحدات الشائعة -->
                <div class="form-section" style="margin-bottom: 30px; padding: 15px; background: #f8f9fa; border-left: 4px solid #3498db;">
                    <div style="display: flex; align-items: center; margin-bottom: 10px;">
                        <i class="fas fa-list-ol" style="margin-left: 8px; color: #3498db;"></i>
                        <h4 style="margin: 0; font-size: 14px; color: #2c3e50; font-weight: 600;">
                            أمثلة على وحدات القياس الشائعة:
                        </h4>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(150px, 1fr)); gap: 10px; font-size: 12px;">
                        <div style="background: white; padding: 8px; border: 1px solid #ecf0f1; cursor: pointer;" 
                             onclick="fillUnitExample('KG', 'كيلوجرام', 'وحدة قياس الوزن')">
                            <div style="color: #3498db; font-weight: bold;">KG</div>
                            <div style="color: #7f8c8d;">كيلوجرام</div>
                        </div>
                        <div style="background: white; padding: 8px; border: 1px solid #ecf0f1; cursor: pointer;" 
                             onclick="fillUnitExample('M', 'متر', 'وحدة قياس الطول')">
                            <div style="color: #3498db; font-weight: bold;">M</div>
                            <div style="color: #7f8c8d;">متر</div>
                        </div>
                        <div style="background: white; padding: 8px; border: 1px solid #ecf0f1; cursor: pointer;" 
                             onclick="fillUnitExample('L', 'لتر', 'وحدة قياس السوائل')">
                            <div style="color: #3498db; font-weight: bold;">L</div>
                            <div style="color: #7f8c8d;">لتر</div>
                        </div>
                        <div style="background: white; padding: 8px; border: 1px solid #ecf0f1; cursor: pointer;" 
                             onclick="fillUnitExample('PCS', 'قطعة', 'وحدة عد القطع')">
                            <div style="color: #3498db; font-weight: bold;">PCS</div>
                            <div style="color: #7f8c8d;">قطعة</div>
                        </div>
                        <div style="background: white; padding: 8px; border: 1px solid #ecf0f1; cursor: pointer;" 
                             onclick="fillUnitExample('BOX', 'صندوق', 'وحدة قياس الصناديق')">
                            <div style="color: #3498db; font-weight: bold;">BOX</div>
                            <div style="color: #7f8c8d;">صندوق</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer Buttons -->
            <div style="background: #f8f9fa; padding: 15px 25px; border-top: 1px solid #ecf0f1; display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 12px; color: #7f8c8d;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 5px;"></i>
                    الحقول المميزة بـ <span style="color: #e74c3c;">*</span> إجبارية
                </div>
                
                <div style="display: flex; gap: 10px;">
                    <a href="units.php" class="btn" 
                       style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                       onmouseover="this.style.background='#7f8c8d'"
                       onmouseout="this.style.background='#95a5a6'">
                        <i class="fas fa-times" style="margin-left: 8px;"></i>
                        إلغاء
                    </a>
                    <button type="submit" class="btn" 
                            style="padding: 8px 25px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                            onmouseover="this.style.background='#27ae60'"
                            onmouseout="this.style.background='#2ecc71'">
                        <i class="fas fa-save" style="margin-left: 8px;"></i>
                        تحديث البيانات
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .form-control:focus {
        outline: none;
    }
    
    .alert-error {
        display: none;
    }
    
    /* Additional styling for better visual */
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-label {
        display: block;
        margin-bottom: 8px;
        color: #2c3e50;
        font-weight: 500;
        font-size: 14px;
    }
</style>

<script>
function showLoader() {
    // Validate form first
    if (validateForm()) {
        document.getElementById('loadingOverlay').style.display = 'flex';
        return true;
    }
    return false;
}

function validateForm() {
    const nameField = document.getElementById('name');
    const codeField = document.getElementById('code');
    let isValid = true;
    
    // Reset styles
    nameField.style.borderColor = '#bdc3c7';
    nameField.style.boxShadow = 'none';
    codeField.style.borderColor = '#bdc3c7';
    codeField.style.boxShadow = 'none';
    
    // Validate name
    if (!nameField.value.trim()) {
        nameField.style.borderColor = '#e74c3c';
        nameField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    }
    
    // Validate code
    if (!codeField.value.trim()) {
        codeField.style.borderColor = '#e74c3c';
        codeField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    }
    
    // Validate code format (should be alphanumeric without spaces)
    if (codeField.value.trim() && !/^[A-Z0-9]{1,10}$/i.test(codeField.value.trim())) {
        codeField.style.borderColor = '#e74c3c';
        codeField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        alert('رمز الوحدة يجب أن يحتوي على أحرف وأرقام فقط (بدون مسافات أو رموز خاصة)');
        isValid = false;
    }
    
    if (!isValid) {
        alert('الرجاء تعبئة الحقول الإجبارية بشكل صحيح');
        return false;
    }
    
    return true;
}

// Auto-format code field to uppercase
document.getElementById('code').addEventListener('input', function(e) {
    this.value = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
});

// Fill unit example when clicked
function fillUnitExample(code, name, description) {
    document.getElementById('code').value = code;
    document.getElementById('name').value = name;
    document.getElementById('description').value = description;
    
    // Show success feedback on the clicked card
    event.currentTarget.style.boxShadow = '0 0 0 2px rgba(52,152,219,0.3)';
    event.currentTarget.style.borderColor = '#3498db';
    setTimeout(() => {
        event.currentTarget.style.boxShadow = 'none';
        event.currentTarget.style.borderColor = '#ecf0f1';
    }, 1000);
}

// Add input event listeners to clear error styles
document.querySelectorAll('.form-control').forEach(field => {
    field.addEventListener('input', function() {
        if (this.value.trim()) {
            this.style.borderColor = '#bdc3c7';
            this.style.boxShadow = 'none';
        }
    });
});

// Show loader if page is taking time to submit (fallback)
setTimeout(() => {
    const loader = document.getElementById('loadingOverlay');
    if (loader && loader.style.display === 'flex') {
        const messages = loader.querySelectorAll('div');
        if (messages.length >= 2) {
            messages[1].textContent = 'لا يزال جاري معالجة البيانات...';
            messages[2].textContent = 'قد تستغرق العملية وقتاً أطول من المتوقع';
        }
    }
}, 5000);
</script>

<?php
include 'views/layout/footer.php';
?>