<?php
// views/layout/header.php
/**
 * ملف هيدر النظام الرئيسي
 * يحتوي على التهيئة الأساسية وتخطيط واجهة المستخدم
 */

// تهيئة الكائنات الأساسية للنظام
require_once $_SERVER['DOCUMENT_ROOT'] . '/gts/config/database.php';

require_once $_SERVER['DOCUMENT_ROOT'] . '/gts/core/Database.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/gts/core/Session.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/gts/core/Auth.php';


// إنشاء مثيلات الكائنات الأساسية
$session = new Session();
$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header('Location: /gts/login.php');
    exit;
}

?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <!-- إعدادات تعريفية أساسية -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="نظام إدارة متكامل">
    
    <!-- عنوان الصفحة الديناميكي -->
    <title><?php echo htmlspecialchars(APP_NAME); ?></title>
    
    <!-- خطوط الويب المخصصة -->
    <link rel="stylesheet" href="fonts/Almarai-local/fonts/fonts.css">
    <link rel="stylesheet" href="fontawesome-free-6.7.2-web/css/all.min.css">
    <!-- الملفات الأساسية للتنسيق -->
    <link rel="stylesheet" href="assets/css/style.css">
    
    <!-- الأنماط المضمنة للتصميم الأساسي -->
    <style>
        :root {
            --primary-color: #0E4262;
            --secondary-color: #F19E2C;
        }
        /* إعادة ضبط الأنماط الأساسية */
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        /* إعدادات عامة للصفحة */
        body {
            font-family: 'Almarai', sans-serif;
            line-height: 1.5;
            color: #333;
            background-color: #f4f4f4;
            min-height: 100vh;
            overflow-x: hidden;
        }
        
        /* حاوية المحتوى الرئيسية */
        .container {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 5px;
        }

        /* ======================================
           تصميم القائمة الجانبية الاحترافية
        ======================================= */
        .sidebar {
            width: 220px;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            height: 100vh;
            position: fixed;
            right: 0;
            top: 0;
            display: flex;
            flex-direction: column;
            padding-top: 20px;
            box-shadow: -2px 0 15px rgba(0, 0, 0, 0.3);
            z-index: 1000;
            overflow-y: auto;
            transition: all 0.3s ease;
        }

        /* تخصيص شريط التمرير للقائمة الجانبية */
        .sidebar::-webkit-scrollbar {
            width: 7px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: #1a2530;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: #3b4b5a;
            border-radius: 4px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: #4a5c6e;
        }

        /* عناصر القائمة */
        .sidebar ul {
            list-style: none;
            padding: 10px 15px;
            flex-grow: 1;
        }

        .sidebar li {
            margin-bottom: 8px;
        }

        .sidebar a {
            display: flex;
            align-items: center;
            padding: 14px 20px;
            color: #e0e6ed;
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            font-size: 16px;
            font-weight: 600;
            position: relative;
            overflow: hidden;
        }

        .sidebar a:hover {
            background: linear-gradient(90deg, #2c3e50 0%, #34495e 100%);
            transform: translateX(-8px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
        }

        .sidebar a::before {
            content: '';
            position: absolute;
            right: 0;
            top: 0;
            height: 100%;
            width: 4px;
            background: #3498db;
            transform: scaleY(0);
            transition: transform 0.3s ease;
        }

        .sidebar a:hover::before {
            transform: scaleY(1);
        }

        /* منطقة المحتوى الرئيسي */
        .main-content {
            padding: 5px 0;
            min-height: calc(100vh - 80px);
            margin-right: 220px;
            transition: all 0.3s ease;
            width: calc(100% - 220px);
        }

        /* ======================================
           أنماط الرسائل والتنبيهات
        ======================================= */
        .alert {
            padding: 1.2rem 1.5rem;
            margin-bottom: 1.5rem;
            border-radius: 8px;
            border: 1px solid transparent;
            font-weight: 500;
            position: relative;
            animation: slideIn 0.3s ease;
        }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .alert-success {
            color: #0f5132;
            background-color: #d1e7dd;
            border-color: #badbcc;
            border-right: 4px solid #198754;
        }

        .alert-error {
            color: #842029;
            background-color: #f8d7da;
            border-color: #f5c2c7;
            border-right: 4px solid #dc3545;
        }

        /* ======================================
           عناصر واجهة المستخدم العامة
        ======================================= */
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 0.75rem 1.5rem;
            background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
            color: white;
            text-decoration: none;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-weight: 600;
            font-size: 15px;
            gap: 8px;
        }

        .btn:hover {
            background: linear-gradient(135deg, #2980b9 0%, #1c5d87 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(41, 128, 185, 0.3);
        }
        .btn-selected{
            background: linear-gradient(135deg, #2980b9 0%, #1c5d87 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(41, 128, 185, 0.3);
        }

        .btn-danger {
            background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
        }

        .btn-danger:hover {
            background: linear-gradient(135deg, #c0392b 0%, #a93226 100%);
            box-shadow: 0 6px 15px rgba(231, 76, 60, 0.3);
        }

        /* الجداول */
       .table {
    width: 100%;
    border-collapse: collapse;      /* دمج الحدود */
    margin-top: 1.5rem;
    background: white;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    border-radius: 0;               /* إلغاء الانحناء */
    border: 1px solid #000;         /* حد خارجي */
}

/* رؤوس وخلايا الجدول */
.table th,
.table td {
    padding: 1rem 1.2rem;
    text-align: right;
    border: 1px solid #000;         /* حدود بين الصفوف والأعمدة */
    transition: background-color 0.2s ease;
    border-radius: 0;               /* بدون انحناء */
}

/* رؤوس الجدول */
.table th {
    background: #f1f1f1;
    font-weight: 700;
    color: #F19E2C;
    
    font-size: 15px;
}


/* تأثير المرور */
.table tbody tr:hover {
    background-color: #f8f9fa;
}


        /* النماذج */
        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.6rem;
            font-weight: 600;
            color: #2c3e50;
            font-size: 15px;
        }

        .form-control {
            width: 100%;
            padding: 0.85rem 1rem;
            border: 2px solid #e0e6ed;
            border-radius: 8px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: #fff;
        }

        .form-control:focus {
            outline: none;
            border-color: #3498db;
            box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.15);
        }

        /* البطاقات */
        .card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            padding: 2rem;
            margin-bottom: 2rem;
            border: 1px solid #e9ecef;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 25px rgba(0, 0, 0, 0.12);
        }

        /* صفحة تسجيل الدخول */
        .login-container {
            max-width: 420px;
            margin: 100px auto;
            padding: 2.5rem;
            background: white;
            border-radius: 16px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            animation: fadeIn 0.5s ease;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Loader شاشة التحميل */
        #page-loader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background:transparent;
            z-index: 9999;
            display: flex;
            justify-content: center;
            align-items: center;
            backdrop-filter: blur(3px);
        }
        
        .loader-content {
            text-align: center;
            color: white;
        }
        
        .loader-spinner {
            width: 70px;
            height: 70px;
            border: 5px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: var(--secondary-color);
            margin: 0 auto 20px;
            animation: spin 1s linear infinite;
        }
        
        .loader-text {
            font-size: 20px;
            font-weight: bold;
            color: var(--secondary-color);
            font-family: 'Almarai', sans-serif;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* استجابة للشاشات الصغيرة */
        @media (max-width: 768px) {
            .sidebar {
                width: 70px;
                padding-top: 15px;
            }
            
            .sidebar a {
                justify-content: center;
                padding: 12px;
            }
            
            .sidebar a span {
                display: none;
            }
            
            .sidebar a:hover {
                transform: translateX(-4px);
            }
            
            .main-content {
                margin-right: 70px;
                width: calc(100% - 70px);
            }
            
            .container {
                width: 95%;
                padding: 0 10px;
            }
        }

        /* ======================================
           تصميم الجوال - مشابه لتطبيق Android
        ======================================= */
        @media screen and (max-width: 767px) {
            /* إخفاء القائمة الجانبية الأصلية في الجوال */
            .sidebar {
                display: none !important;
                width: 0 !important;
                opacity: 0 !important;
                visibility: hidden !important;
                transform: translateX(100%) !important;
            }
            
            /* شريط الجوال - ثابت في الأعلى */
            .mobile-navbar {
                display: flex !important;
                position: fixed;
                top: 0;
                right: 0;
                left: 0;
                height: 60px;
                background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
                z-index: 1001;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
                padding: 0 5px;
                overflow-x: auto;
                overflow-y: hidden;
                align-items: center;
            }
            
            .mobile-nav-container {
                display: flex;
                align-items: center;
                height: 100%;
                width: 100%;
                overflow-x: auto;
                overflow-y: hidden;
                -webkit-overflow-scrolling: touch;
                scrollbar-width: none;
                -ms-overflow-style: none;
                padding: 0 5px;
            }
            
            .mobile-nav-container::-webkit-scrollbar {
                display: none;
            }
            
            .mobile-nav-item {
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                min-width: 65px;
                height: 60px;
                padding: 5px 8px;
                color: white;
                text-decoration: none;
                font-size: 10px;
                text-align: center;
                transition: all 0.2s ease;
                flex-shrink: 0;
                border-radius: 8px;
            }
            
            .mobile-nav-item i {
                font-size: 20px;
                margin-bottom: 3px;
            }
            
            .mobile-nav-item span {
                font-size: 9px;
                line-height: 1.2;
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
                max-width: 60px;
                display: block;
            }
            
            .mobile-nav-item:hover,
            .mobile-nav-item:active,
            .mobile-nav-item.btn-selected {
                background: rgba(255, 255, 255, 0.15);
            }
            
            /* تعديل المحتوى الرئيسي للجوال */
            .main-content {
                margin-right: 0 !important;
                margin-left: 0 !important;
                padding: 70px 10px 20px !important;
                min-height: calc(100vh - 60px);
                width: 100% !important;
                max-width: 100% !important;
            }
            
            .container {
                width: 100% !important;
                padding: 0 10px !important;
                max-width: 100% !important;
                margin: 0 auto !important;
            }
            
            /* تحسين حجم الخطوط والعناصر للجوال */
            .card {
                padding: 1rem;
                margin-bottom: 1rem;
                border-radius: 10px;
                width: 100%;
                overflow-x: hidden;
            }
            
            .btn {
                padding: 0.6rem 1rem;
                font-size: 14px;
            }
            
            .table {
                display: block;
                overflow-x: auto;
            }
            
            .table th,
            .table td {
                padding: 0.6rem 0.8rem;
                font-size: 13px;
                min-width: 100px;
            }
            
            .form-control {
                padding: 0.7rem 0.9rem;
                font-size: 15px;
                width: 100%;
            }
            
            /* تحسين التنبيهات للجوال */
            .alert {
                padding: 1rem;
                font-size: 14px;
                margin-bottom: 1rem;
                width: 100%;
            }
            
            /* تحسين صفحة تسجيل الدخول للجوال */
            .login-container {
                margin: 60px auto 20px;
                padding: 1.5rem;
                width: 95%;
                max-width: 100%;
            }
            
            /* تحسين الـ Loader للجوال */
            .loader-text {
                font-size: 16px;
            }
            
            .loader-spinner {
                width: 50px;
                height: 50px;
            }
            
            /* أنماط قائمة المزيد للجوال */
            .mobile-more-grid {
                display: grid;
                grid-template-columns: repeat(3, 1fr);
                gap: 12px;
                padding: 10px;
            }
            
            .mobile-more-item {
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                padding: 12px 5px;
                background: #f8f9fa;
                border-radius: 10px;
                text-decoration: none;
                color: #333;
                transition: all 0.2s ease;
                text-align: center;
                min-height: 80px;
            }
            
            .mobile-more-item i {
                font-size: 22px;
                margin-bottom: 6px;
            }
            
            .mobile-more-item span {
                font-size: 10px;
                line-height: 1.3;
                max-width: 70px;
            }
            
            .mobile-more-item:hover {
                background: #e9ecef;
                transform: translateY(-2px);
            }
            
            .mobile-more-item.btn-selected {
                background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
                color: white;
            }
            
            .mobile-overlay {
                position: fixed;
                top: 0;
                right: 0;
                bottom: 0;
                left: 0;
                background: rgba(0,0,0,0.5);
                z-index: 1001;
                display: none;
                opacity: 0;
                transition: opacity 0.3s ease;
            }
            
            /* إصلاح شريط التمرير الأفقي */
            body.mobile-mode {
                overflow-x: hidden;
            }
        }

        /* لشاشات صغيرة جداً (هواتف أفقية) */
        @media screen and (max-width: 480px) {
            .mobile-nav-item {
                min-width: 60px;
                padding: 5px 6px;
            }
            
            .mobile-nav-item span {
                font-size: 8px;
                max-width: 55px;
            }
            
            .mobile-nav-item i {
                font-size: 18px;
            }
            
            .mobile-more-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }
    </style>
</head>
<body>


    <?php
$currentPage = basename($_SERVER['PHP_SELF']);
?>
    <!-- ======================================
         القائمة الجانبية للمستخدمين المسجلين
    ======================================= -->
    <aside class="sidebar">
      <nav>
    <ul>

        <!-- الرئيسية -->
        <li>
            <a href="index.php" class="<?= $currentPage == 'index.php' ? 'btn-selected' : '' ?>">
                🏠 الرئيسية
            </a>
        </li>

        <!-- العملاء -->
        <?php if ($auth->checkPermission('customers', 'read')): ?>
        <li>
            <a href="customers.php" class="<?= $currentPage == 'customers.php' ? 'btn-selected' : '' ?>">
                👥 العملاء
            </a>
        </li>
        <?php endif; ?>

        <!-- الشركات الموردة -->
        <?php if ($auth->checkPermission('companies', 'read')): ?>
        <li>
            <a href="companies.php" class="<?= $currentPage == 'companies.php' ? 'btn-selected' : '' ?>">
                🏢 الشركات الموردة
            </a>
        </li>
        <?php endif; ?>

        <!-- العملات -->
        <?php if ($auth->checkPermission('currencies', 'read')): ?>
        <li>
            <a href="currencies.php" class="<?= $currentPage == 'currencies.php' ? 'btn-selected' : '' ?>">
                💱 العملات
            </a>
        </li>
        <?php endif; ?>

        <!-- وحدات القياس -->
        <?php if ($auth->checkPermission('units', 'read')): ?>
        <li>
            <a href="units.php" class="<?= $currentPage == 'units.php' ? 'btn-selected' : '' ?>">
                📏 وحدات القياس
            </a>
        </li>
        <?php endif; ?>

        <!-- الأصناف -->
        <?php if ($auth->checkPermission('items', 'read')): ?>
        <li>
            <a href="items.php" class="<?= $currentPage == 'items.php' ? 'btn-selected' : '' ?>">
                📦 الأصناف
            </a>
        </li>
        <?php endif; ?>

        <!-- المستخدمين -->
        <?php if ($auth->checkPermission('users', 'read')): ?>
        <li>
            <a href="users.php" class="<?= $currentPage == 'users.php' ? 'btn-selected' : '' ?>">
                👤 المستخدمين
            </a>
        </li>
        <?php endif; ?>

        <!-- الفواتير -->
        <?php if ($auth->checkPermission('invoices', 'read')): ?>
        <li>
            <a href="invoices.php" class="<?= $currentPage == 'invoices.php' ? 'btn-selected' : '' ?>">
                🧾 الفواتير
            </a>
        </li>
        <?php endif; ?>

        <!-- السندات -->
        <?php if ($auth->checkPermission('invoices', 'read')): ?>
        <li>
            <a href="reports_vouchers/vouchers.php"
               class="<?= $currentPage == 'vouchers.php' ? 'btn-selected' : '' ?>">
                📑 السندات
            </a>
        </li>
        <?php endif; ?>

        <!-- الصناديق -->
        <?php if ($auth->checkPermission('invoices', 'read')): ?>
        <li>
            <a href="reports_vouchers/cash_boxes.php"
               class="<?= $currentPage == 'cash_boxes.php' ? 'btn-selected' : '' ?>">
                💼 الصناديق
            </a>
        </li>
        <?php endif; ?>

        <!-- البنوك -->
        <?php if ($auth->checkPermission('invoices', 'read')): ?>
        <li>
            <a href="reports_vouchers/bank_accounts.php"
               class="<?= $currentPage == 'bank_accounts.php' ? 'btn-selected' : '' ?>">
                🏦 البنوك
            </a>
        </li>
        <?php endif; ?>

        <!-- التقارير -->
        <?php if ($auth->checkPermission('invoices', 'read')): ?>
        <li>
            <a href="reports_vouchers/accounts.php"
               class="<?= $currentPage == 'accounts.php' ? 'btn-selected' : '' ?>">
                📊 التقارير
            </a>
        </li>
        <?php endif; ?>

        <!-- تسجيل الخروج -->
        <li>
            <a href="logout.php">
                🚪 تسجيل الخروج
            </a>
        </li>

    </ul>
</nav>

    </aside>

    <!-- ======================================
         شريط الجوال - مشابه لتطبيق Android
    ======================================= -->
    <nav class="mobile-navbar" style="display: none;">
        <div class="mobile-nav-container">
            <!-- الرئيسية -->
            <a href="index.php" class="mobile-nav-item <?= $currentPage == 'index.php' ? 'btn-selected' : '' ?>">
                🏠<span>الرئيسية</span>
            </a>

            <!-- العملاء -->
            <?php if ($auth->checkPermission('customers', 'read')): ?>
            <a href="customers.php" class="mobile-nav-item <?= $currentPage == 'customers.php' ? 'btn-selected' : '' ?>">
                👥<span>العملاء</span>
            </a>
            <?php endif; ?>

            <!-- الشركات الموردة -->
            <?php if ($auth->checkPermission('companies', 'read')): ?>
            <a href="companies.php" class="mobile-nav-item <?= $currentPage == 'companies.php' ? 'btn-selected' : '' ?>">
                🏢<span>الشركات</span>
            </a>
            <?php endif; ?>

            <!-- العملات -->
            <?php if ($auth->checkPermission('currencies', 'read')): ?>
            <a href="currencies.php" class="mobile-nav-item <?= $currentPage == 'currencies.php' ? 'btn-selected' : '' ?>">
                💱<span>العملات</span>
            </a>
            <?php endif; ?>

            <!-- الأصناف -->
            <?php if ($auth->checkPermission('items', 'read')): ?>
            <a href="items.php" class="mobile-nav-item <?= $currentPage == 'items.php' ? 'btn-selected' : '' ?>">
                📦<span>الأصناف</span>
            </a>
            <?php endif; ?>

            <!-- الفواتير -->
            <?php if ($auth->checkPermission('invoices', 'read')): ?>
            <a href="invoices.php" class="mobile-nav-item <?= $currentPage == 'invoices.php' ? 'btn-selected' : '' ?>">
                🧾<span>الفواتير</span>
            </a>
            <?php endif; ?>

            <!-- المزيد -->
            <a href="javascript:void(0)" class="mobile-nav-item more-menu-btn">
                ⋮<span>المزيد</span>
            </a>
        </div>
    </nav>

    <!-- ======================================
         قائمة المزيد للجوال
    ======================================= -->
    <div class="mobile-more-menu" style="display: none; position: fixed; bottom: 0; right: 0; left: 0; background: white; z-index: 1002; border-radius: 20px 20px 0 0; box-shadow: 0 -2px 20px rgba(0,0,0,0.2); padding: 20px; max-height: 70vh; overflow-y: auto;">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 1px solid #eee;">
            <h3 style="margin: 0; color: var(--primary-color);">القائمة الكاملة</h3>
            <button class="close-more-menu" style="background: none; border: none; font-size: 24px; color: #666; cursor: pointer;">×</button>
        </div>
        
        <div class="mobile-more-grid">
            <!-- وحدات القياس -->
            <?php if ($auth->checkPermission('units', 'read')): ?>
            <a href="units.php" class="mobile-more-item <?= $currentPage == 'units.php' ? 'btn-selected' : '' ?>">
                📏<span>وحدات القياس</span>
            </a>
            <?php endif; ?>

            <!-- المستخدمين -->
            <?php if ($auth->checkPermission('users', 'read')): ?>
            <a href="users.php" class="mobile-more-item <?= $currentPage == 'users.php' ? 'btn-selected' : '' ?>">
                👤<span>المستخدمين</span>
            </a>
            <?php endif; ?>

            <!-- السندات -->
            <?php if ($auth->checkPermission('invoices', 'read')): ?>
            <a href="reports_vouchers/vouchers.php" class="mobile-more-item <?= $currentPage == 'vouchers.php' ? 'btn-selected' : '' ?>">
                📑<span>السندات</span>
            </a>
            <?php endif; ?>

            <!-- الصناديق -->
            <?php if ($auth->checkPermission('invoices', 'read')): ?>
            <a href="reports_vouchers/cash_boxes.php" class="mobile-more-item <?= $currentPage == 'cash_boxes.php' ? 'btn-selected' : '' ?>">
                💼<span>الصناديق</span>
            </a>
            <?php endif; ?>

            <!-- البنوك -->
            <?php if ($auth->checkPermission('invoices', 'read')): ?>
            <a href="reports_vouchers/bank_accounts.php" class="mobile-more-item <?= $currentPage == 'bank_accounts.php' ? 'btn-selected' : '' ?>">
                🏦<span>البنوك</span>
            </a>
            <?php endif; ?>

            <!-- التقارير -->
            <?php if ($auth->checkPermission('invoices', 'read')): ?>
            <a href="reports_vouchers/accounts.php" class="mobile-more-item <?= $currentPage == 'accounts.php' ? 'btn-selected' : '' ?>">
                📊<span>التقارير</span>
            </a>
            <?php endif; ?>

            <!-- تسجيل الخروج -->
            <a href="logout.php" class="mobile-more-item" style="color: #e74c3c;">
                🚪<span>تسجيل الخروج</span>
            </a>
        </div>
    </div>

    <!-- ======================================
         سكريبت إدارة تصميم الجوال
    ======================================= -->
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // التحقق من حجم الشاشة
        function checkScreenSize() {
            const mobileNavbar = document.querySelector('.mobile-navbar');
            const sidebar = document.querySelector('.sidebar');
            const mainContent = document.querySelector('.main-content');
            
            if (window.innerWidth <= 480) {
                // وضع الجوال
                if (mobileNavbar) mobileNavbar.style.display = 'block';
                if (sidebar) sidebar.style.display = 'none';
                if (mainContent) mainContent.style.marginRight = '0';
            } else if (window.innerWidth <= 768) {
                // وضع التابلت - العرض المصغر للشريط الجانبي
                if (mobileNavbar) mobileNavbar.style.display = 'none';
                if (sidebar) sidebar.style.display = 'flex';
                if (mainContent) mainContent.style.marginRight = '70px';
            } else {
                // وضع سطح المكتب الكامل
                if (mobileNavbar) mobileNavbar.style.display = 'none';
                if (sidebar) sidebar.style.display = 'flex';
                if (mainContent) mainContent.style.marginRight = '220px';
            }
        }
        
        // التحقق الأولي
        checkScreenSize();
        
        // الاستماع لتغيير حجم النافذة
        window.addEventListener('resize', checkScreenSize);
        
        // إدارة قائمة المزيد للجوال
        const moreMenuBtn = document.querySelector('.more-menu-btn');
        const moreMenu = document.querySelector('.mobile-more-menu');
        const closeMoreMenu = document.querySelector('.close-more-menu');
        const overlay = document.createElement('div');
        overlay.className = 'mobile-overlay';
        document.body.appendChild(overlay);
        
        if (moreMenuBtn && moreMenu) {
            moreMenuBtn.addEventListener('click', function() {
                moreMenu.style.display = 'block';
                overlay.style.display = 'block';
                setTimeout(() => {
                    moreMenu.style.transform = 'translateY(0)';
                    overlay.style.opacity = '1';
                }, 10);
            });
            
            closeMoreMenu.addEventListener('click', closeMoreMenuFunc);
            overlay.addEventListener('click', closeMoreMenuFunc);
            
            function closeMoreMenuFunc() {
                moreMenu.style.transform = 'translateY(100%)';
                overlay.style.opacity = '0';
                setTimeout(() => {
                    moreMenu.style.display = 'none';
                    overlay.style.display = 'none';
                }, 300);
            }
            
            // تهيئة التحريك
            moreMenu.style.transition = 'transform 0.3s ease';
            overlay.style.transition = 'opacity 0.3s ease';
            moreMenu.style.transform = 'translateY(100%)';
        }
        
        // جعل روابط قائمة المزيد تعمل مثل الروابط العادية
        document.querySelectorAll('.mobile-more-item').forEach(item => {
            item.addEventListener('click', function(e) {
                if (this.getAttribute('href') !== 'javascript:void(0)') {
                    closeMoreMenuFunc();
                    // إظهار الـ Loader إذا كان موجودًا
                    const loader = document.getElementById('page-loader');
                    if (loader) loader.style.display = 'flex';
                }
            });
        });
    });
    </script>


<!-- ======================================
     المحتوى الرئيسي للصفحة
======================================= -->
<main class="main-content">
    <div class="container">
        <!-- عرض رسائل النظام -->
        <?php
        $flash = $session->getFlash();
        if ($flash): ?>
            <div class="alert alert-<?php echo $flash['type'] === 'error' ? 'error' : 'success'; ?>">
                <?php echo htmlspecialchars($flash['message'], ENT_QUOTES, 'UTF-8'); ?>
            </div>
        <?php endif; ?>

<!-- ======================================
     Loader شاشة التحميل
======================================= -->
<div id="page-loader" style="display: none;">
    <div class="loader-content">
        <div class="loader-spinner"></div>
        <div class="loader-text">جاري التحميل...</div>
    </div>
</div>

<!-- إضافة سكريبت للتحكم في الـ Loader -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const loader = document.getElementById('page-loader');
        const allLinks = document.querySelectorAll('a:not([href^="#"]):not([href*="javascript"])');
        
        // إظهار Loader عند النقر على أي رابط
        allLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                // التحقق إذا كان الرابط يفتح في نافذة جديدة أو علامة تبويب جديدة
                if (this.target === '_blank' || this.hasAttribute('download')) {
                    return;
                }
                
                // التحقق إذا كان الرابط رابط خارجي
                if (this.href && !this.href.startsWith(window.location.origin)) {
                    return;
                }
                
                // إظهار الـ Loader
                loader.style.display = 'flex';
                
                // إخفاء الـ Loader بعد 30 ثانية كحد أقصى (حماية)
                setTimeout(() => {
                    loader.style.display = 'none';
                }, 30000);
            });
        });
        
        // إخفاء الـ Loader عندما يتم تحميل الصفحة بالكامل
        window.addEventListener('load', function() {
            setTimeout(() => {
                loader.style.display = 'none';
            }, 500);
        });
        
        // إخفاء الـ Loader عند الضغط على زر الرجوع في المتصفح
        window.addEventListener('pageshow', function(event) {
            if (event.persisted) {
                loader.style.display = 'none';
            }
        });
    });
</script>