<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0;padding: 8px;  margin: 5px auto; max-width: 1200px;">
 <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;  position: sticky; top: 0;
z-index: 1100;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-cube" style="margin-left: 8px;"></i>
                إضافة صنف جديد
            </h2>
            <div style="font-size: 12px; opacity: 0.8;">
                <span class="badge" style="background: #2ecc71; padding: 4px 8px; border-radius: 0;">صنف جديد</span>
            </div>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <?php if (!empty($error)): ?>
        <div class="alert alert-danger" style="margin: 0; border-radius: 0; border: none; border-bottom: 1px solid #e74c3c; background: #ffe6e6; padding: 12px 20px; display: flex; align-items: center;">
            <i class="fas fa-exclamation-circle" style="margin-left: 10px; color: #e74c3c;"></i>
            <span><?php echo htmlspecialchars($error); ?></span>
        </div>
        <?php endif; ?>

        <!-- Loader Overlay -->
        <div id="loadingOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255,255,255,0.9); z-index: 9999; justify-content: center; align-items: center; flex-direction: column;">
            <div class="loader" style="width: 50px; height: 50px; border: 5px solid #f3f3f3; border-top: 5px solid #eaa033; border-radius: 50%; animation: spin 1s linear infinite; margin-bottom: 20px;"></div>
            <div style="color: #2c3e50; font-size: 16px; font-weight: 500;">جاري حفظ الصنف الجديد...</div>
            <div style="color: #7f8c8d; font-size: 14px; margin-top: 10px;">يرجى الانتظار</div>
        </div>

        <form method="POST" action="" enctype="multipart/form-data" id="itemForm" onsubmit="showLoader()">
            <div style="padding: 25px;">
                <!-- معلومات أساسية -->
                <div class="form-section" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #ecf0f1;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #3498db; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-info-circle" style="margin-left: 8px; color: #3498db;"></i>
                            المعلومات الأساسية
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="name" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> اسم الصنف
                            </label>
                            <input type="text" class="form-control" id="name" name="name" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; transition: border-color 0.3s;"
                                   onfocus="this.style.borderColor='#3498db'; this.style.boxShadow='0 0 0 2px rgba(52,152,219,0.2)';"
                                   onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none';"
                                   value="<?php echo htmlspecialchars($_POST['name'] ?? ''); ?>"
                                   placeholder="أدخل اسم الصنف">
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="model" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                الموديل
                            </label>
                            <input type="text" class="form-control" id="model" name="model" 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                   value="<?php echo htmlspecialchars($_POST['model'] ?? ''); ?>"
                                   placeholder="أدخل الموديل">
                        </div>
                    </div>
                </div>

                <!-- الصورة -->
                <div class="form-section" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #ecf0f1;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #9b59b6; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-image" style="margin-left: 8px; color: #9b59b6;"></i>
                            صورة الصنف
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                        <!-- معاينة الصورة -->
                        <div class="form-group">
                            <label class="form-label" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                معاينة الصورة
                            </label>
                            <div id="imagePreviewContainer" style="border: 2px solid #ecf0f1; padding: 20px; text-align: center; background: #f8f9fa; min-height: 200px; display: flex; justify-content: center; align-items: center;">
                                <div id="noImagePreview" style="text-align: center;">
                                    <i class="far fa-image" style="font-size: 48px; color: #bdc3c7; margin-bottom: 15px;"></i>
                                    <div style="color: #7f8c8d; font-size: 14px; margin-bottom: 5px;">لا توجد صورة</div>
                                    <div style="color: #95a5a6; font-size: 12px;">ستظهر معاينة الصورة هنا</div>
                                </div>
                                <img id="imagePreview" src="" alt="معاينة الصورة" 
                                     style="max-width: 100%; max-height: 180px; object-fit: contain; display: none;">
                            </div>
                        </div>
                        
                        <!-- منطقة رفع الصورة -->
                        <div class="form-group">
                            <label class="form-label" for="image" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                رفع الصورة
                            </label>
                            <div id="dropZone" 
                                 style="border: 2px dashed #bdc3c7; padding: 25px; text-align: center; background: #f8f9fa; cursor: pointer; transition: all 0.3s ease; min-height: 200px; display: flex; flex-direction: column; justify-content: center; align-items: center;"
                                 onclick="document.getElementById('image').click()">
                                <input type="file" class="form-control" id="image" name="image" accept="image/*" 
                                       style="display: none;"
                                       onchange="handleFileSelect(this)">
                                <i class="fas fa-cloud-upload-alt" style="font-size: 32px; color: #7f8c8d; margin-bottom: 15px; transition: color 0.3s;"></i>
                                <div style="color: #7f8c8d; font-size: 16px; margin-bottom: 5px; font-weight: 500;">
                                    انقر لاختيار صورة
                                </div>
                                <div style="color: #95a5a6; font-size: 13px; margin-bottom: 10px;">
                                    أو اسحب وأفلت الصورة هنا
                                </div>
                                <div id="fileName" style="color: #3498db; font-size: 12px; margin-top: 10px; padding: 5px 10px; background: rgba(52, 152, 219, 0.1); border-radius: 3px;"></div>
                                <div id="uploadProgress" style="width: 100%; max-width: 200px; background: #ecf0f1; height: 4px; margin-top: 15px; border-radius: 2px; overflow: hidden; display: none;">
                                    <div id="progressBar" style="height: 100%; background: #2ecc71; width: 0%; transition: width 0.3s;"></div>
                                </div>
                            </div>
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 8px;">
                                <i class="fas fa-info-circle"></i> الحد الأقصى: 5MB - المسموح: JPG, PNG, GIF, WEBP
                            </small>
                        </div>
                    </div>
                </div>

                <!-- الأسعار والمخزون -->
                <div class="form-section" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #ecf0f1;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #27ae60; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-dollar-sign" style="margin-left: 8px; color: #27ae60;"></i>
                            الأسعار والمخزون
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="default_price" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> السعر الافتراضي
                            </label>
                            <div style="position: relative;">
                                <input type="number" step="0.01" class="form-control" id="default_price" name="default_price" required 
                                       style="width: 100%; padding: 10px 12px 10px 30px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                       value="<?php echo htmlspecialchars($_POST['default_price'] ?? '0'); ?>">
                                <span style="position: absolute; left: 10px; top: 50%; transform: translateY(-50%); color: #7f8c8d;">¥</span>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="current_stock" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                المخزون الحالي
                            </label>
                            <input type="number" step="0.001" class="form-control" id="current_stock" name="current_stock" 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                   value="<?php echo htmlspecialchars($_POST['current_stock'] ?? '0'); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="unit_id" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> وحدة القياس
                            </label>
                            <select class="form-control" id="unit_id" name="unit_id" required 
                                    style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; background: white; cursor: pointer;">
                                <option value="">اختر وحدة القياس</option>
                                <?php foreach ($units as $unit): ?>
                                    <option value="<?php echo $unit['id']; ?>" 
                                            <?php echo (($_POST['unit_id'] ?? '') == $unit['id']) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($unit['name'] . ' (' . $unit['code'] . ')'); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- معلومات إضافية -->
                <div class="form-section" style="margin-bottom: 30px;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #e67e22; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-file-alt" style="margin-left: 8px; color: #e67e22;"></i>
                            معلومات إضافية
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="company_id" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                الشركة الموردة
                            </label>
                            <select class="form-control" id="company_id" name="company_id"
                                    style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; background: white; cursor: pointer;">
                                <option value="">اختر الشركة الموردة (اختياري)</option>
                                <?php foreach ($companies as $company): ?>
                                    <option value="<?php echo $company['id']; ?>" 
                                            <?php echo (($_POST['company_id'] ?? '') == $company['id']) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($company['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="specifications" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                المواصفات
                            </label>
                            <textarea class="form-control" id="specifications" name="specifications" rows="4"
                                      style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; resize: vertical;"
                                      placeholder="أدخل مواصفات الصنف هنا..."><?php echo htmlspecialchars($_POST['specifications'] ?? ''); ?></textarea>
                        </div>
                    </div>
                </div>

            </div>

            <!-- Footer Buttons -->
            <div style="background: #f8f9fa; padding: 15px 25px; border-top: 1px solid #ecf0f1; display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 12px; color: #7f8c8d;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 5px;"></i>
                    الحقول المميزة بـ <span style="color: #e74c3c;">*</span> إجبارية
                </div>
                
                <div style="display: flex; gap: 10px;">
                    <a href="items.php" class="btn" 
                       style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                       onmouseover="this.style.background='#7f8c8d'"
                       onmouseout="this.style.background='#95a5a6'">
                        <i class="fas fa-times" style="margin-left: 8px;"></i>
                        إلغاء
                    </a>
                    <button type="submit" class="btn" 
                            style="padding: 8px 25px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                            onmouseover="this.style.background='#27ae60'"
                            onmouseout="this.style.background='#2ecc71'">
                        <i class="fas fa-save" style="margin-left: 8px;"></i>
                        حفظ الصنف
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    @keyframes pulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.05); }
        100% { transform: scale(1); }
    }
    
    .form-control:focus {
        outline: none;
    }
    
    select.form-control {
        appearance: none;
        background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='%237f8c8d' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3e%3cpolyline points='6 9 12 15 18 9'%3e%3c/polyline%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 10px center;
        background-size: 15px;
    }
    
    .drop-zone-active {
        border-color: #3498db !important;
        background: #e8f4fd !important;
        animation: pulse 0.5s ease;
    }
    
    .drop-zone-active i {
        color: #3498db !important;
    }
</style>

<script>
function showLoader() {
    // Validate form first
    if (validateForm()) {
        document.getElementById('loadingOverlay').style.display = 'flex';
        return true;
    }
    return false;
}

function validateForm() {
    const nameField = document.getElementById('name');
    const priceField = document.getElementById('default_price');
    const unitField = document.getElementById('unit_id');
    let isValid = true;
    
    // Reset styles
    nameField.style.borderColor = '#bdc3c7';
    nameField.style.boxShadow = 'none';
    priceField.style.borderColor = '#bdc3c7';
    priceField.style.boxShadow = 'none';
    unitField.style.borderColor = '#bdc3c7';
    unitField.style.boxShadow = 'none';
    
    // Validate name
    if (!nameField.value.trim()) {
        nameField.style.borderColor = '#e74c3c';
        nameField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    }
    
    // Validate price
    const price = parseFloat(priceField.value);
    if (!priceField.value.trim() || isNaN(price) || price <= 0) {
        priceField.style.borderColor = '#e74c3c';
        priceField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        alert('السعر يجب أن يكون رقماً أكبر من الصفر');
        isValid = false;
    }
    
    // Validate unit
    if (!unitField.value) {
        unitField.style.borderColor = '#e74c3c';
        unitField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    }
    
    if (!isValid) {
        alert('الرجاء تعبئة الحقول الإجبارية بشكل صحيح');
        return false;
    }
    
    return true;
}

function handleFileSelect(input) {
    const fileName = document.getElementById('fileName');
    const noImagePreview = document.getElementById('noImagePreview');
    const imagePreview = document.getElementById('imagePreview');
    const progressBar = document.getElementById('progressBar');
    const uploadProgress = document.getElementById('uploadProgress');
    
    if (input.files && input.files[0]) {
        const file = input.files[0];
        
        // Validate file size (max 5MB)
        if (file.size > 5 * 1024 * 1024) {
            alert('حجم الصورة يجب أن يكون أقل من 5MB');
            input.value = '';
            fileName.textContent = '';
            return;
        }
        
        // Validate file type
        const validTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        if (!validTypes.includes(file.type)) {
            alert('نوع الملف غير مدعوم. الرجاء اختيار صورة من نوع JPG, PNG, GIF, أو WEBP');
            input.value = '';
            fileName.textContent = '';
            return;
        }
        
        // Show upload progress
        uploadProgress.style.display = 'block';
        progressBar.style.width = '100%';
        
        // Show file name
        fileName.textContent = file.name;
        fileName.innerHTML += ' <span style="color:#27ae60;">✓</span>';
        
        // Simulate upload progress
        let progress = 0;
        const interval = setInterval(() => {
            progress += 10;
            progressBar.style.width = progress + '%';
            
            if (progress >= 100) {
                clearInterval(interval);
                setTimeout(() => {
                    uploadProgress.style.display = 'none';
                    progressBar.style.width = '0%';
                }, 500);
            }
        }, 100);
        
        // Preview image
        const reader = new FileReader();
        reader.onload = function(e) {
            noImagePreview.style.display = 'none';
            imagePreview.src = e.target.result;
            imagePreview.style.display = 'block';
        };
        reader.readAsDataURL(file);
    } else {
        fileName.textContent = '';
        noImagePreview.style.display = 'block';
        imagePreview.style.display = 'none';
    }
}

// Drag and drop functionality
const dropZone = document.getElementById('dropZone');
const fileInput = document.getElementById('image');

// Prevent default drag behaviors
['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
    dropZone.addEventListener(eventName, preventDefaults, false);
    document.body.addEventListener(eventName, preventDefaults, false);
});

function preventDefaults(e) {
    e.preventDefault();
    e.stopPropagation();
}

// Highlight drop zone when item is dragged over it
['dragenter', 'dragover'].forEach(eventName => {
    dropZone.addEventListener(eventName, highlight, false);
});

['dragleave', 'drop'].forEach(eventName => {
    dropZone.addEventListener(eventName, unhighlight, false);
});

function highlight(e) {
    dropZone.classList.add('drop-zone-active');
}

function unhighlight(e) {
    dropZone.classList.remove('drop-zone-active');
}

// Handle dropped files
dropZone.addEventListener('drop', handleDrop, false);

function handleDrop(e) {
    const dt = e.dataTransfer;
    const files = dt.files;
    
    if (files.length > 0) {
        fileInput.files = files;
        handleFileSelect(fileInput);
    }
}

// Add input event listeners to clear error styles
document.querySelectorAll('.form-control').forEach(field => {
    field.addEventListener('input', function() {
        if (this.value.trim()) {
            this.style.borderColor = '#bdc3c7';
            this.style.boxShadow = 'none';
        }
    });
});

// Handle select change
document.getElementById('unit_id').addEventListener('change', function() {
    if (this.value) {
        this.style.borderColor = '#bdc3c7';
        this.style.boxShadow = 'none';
    }
});

// Show loader if page is taking time to submit (fallback)
setTimeout(() => {
    const loader = document.getElementById('loadingOverlay');
    if (loader && loader.style.display === 'flex') {
        const messages = loader.querySelectorAll('div');
        if (messages.length >= 2) {
            messages[1].textContent = 'لا يزال جاري معالجة البيانات...';
            messages[2].textContent = 'قد تستغرق العملية وقتاً أطول من المتوقع';
        }
    }
}, 5000);

// Add click handler for the entire drop zone to trigger file input
dropZone.addEventListener('click', function(e) {
    if (e.target !== fileInput) {
        fileInput.click();
    }
});
</script>

<?php
include 'views/layout/footer.php';
?>