<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0;padding: 8px;  margin: 5px auto; max-width: 1200px;">
 <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;  position: sticky; top: 0;
z-index: 1100;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-coins" style="margin-left: 8px;"></i>
                تعديل العملة
            </h2>
            <div style="font-size: 12px; opacity: 0.8;">
                <span class="badge" style="background: #f39c12; padding: 4px 8px; border-radius: 0;">تعديل بيانات</span>
            </div>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <?php if (!empty($error)): ?>
        <div class="alert alert-danger" style="margin: 0; border-radius: 0; border: none; border-bottom: 1px solid #e74c3c; background: #ffe6e6; padding: 12px 20px; display: flex; align-items: center;">
            <i class="fas fa-exclamation-circle" style="margin-left: 10px; color: #e74c3c;"></i>
            <span><?php echo htmlspecialchars($error); ?></span>
        </div>
        <?php endif; ?>

        <!-- Loader Overlay -->
        <div id="loadingOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255,255,255,0.9); z-index: 9999; justify-content: center; align-items: center; flex-direction: column;">
            <div class="loader" style="width: 50px; height: 50px; border: 5px solid #f3f3f3; border-top: 5px solid #f39c12; border-radius: 50%; animation: spin 1s linear infinite; margin-bottom: 20px;"></div>
            <div style="color: #2c3e50; font-size: 16px; font-weight: 500;">جاري تحديث بيانات العملة...</div>
            <div style="color: #7f8c8d; font-size: 14px; margin-top: 10px;">يرجى الانتظار</div>
        </div>

        <form method="POST" action="" id="currencyForm" onsubmit="showLoader()">
            <input type="hidden" name="id" value="<?php echo $currency['id']; ?>">
            
            <div style="padding: 25px;">
                <!-- معلومات العملة الأساسية -->
                <div class="form-section" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #ecf0f1;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #f39c12; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-info-circle" style="margin-left: 8px; color: #f39c12;"></i>
                            المعلومات الأساسية
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="name" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> اسم العملة
                            </label>
                            <input type="text" class="form-control" id="name" name="name" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; transition: border-color 0.3s;"
                                   onfocus="this.style.borderColor='#f39c12'; this.style.boxShadow='0 0 0 2px rgba(243,156,18,0.2)';"
                                   onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none';"
                                   value="<?php echo htmlspecialchars($currency['name']); ?>"
                                   placeholder="أدخل اسم العملة">
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> الاسم الكامل للعملة (مثال: الريال السعودي)
                            </small>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="code" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> رمز العملة
                            </label>
                            <input type="text" class="form-control" id="code" name="code" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; text-transform: uppercase;"
                                   value="<?php echo htmlspecialchars($currency['code']); ?>"
                                   placeholder="أدخل رمز العملة"
                                   oninput="this.value = this.value.toUpperCase()">
                            <div style="background: #f8f9fa; padding: 8px; margin-top: 8px; border-left: 3px solid #f39c12;">
                                <div style="font-size: 12px; color: #7f8c8d;">
                                    <i class="fas fa-lightbulb" style="margin-left: 5px; color: #f39c12;"></i>
                                    <strong>مثال:</strong> SAR, USD, EUR, GBP, JPY
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="symbol" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                رمز العملة
                            </label>
                            <input type="text" class="form-control" id="symbol" name="symbol" 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                   value="<?php echo htmlspecialchars($currency['symbol']); ?>"
                                   placeholder="أدخل رمز العملة">
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> الرمز النقدي (مثال: $, €, ¥, £)
                            </small>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="exchange_rate" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> سعر الصرف
                            </label>
                            <div style="position: relative;">
                                <input type="number" step="0.000001" class="form-control" id="exchange_rate" name="exchange_rate" required 
                                       style="width: 100%; padding: 10px 12px 10px 35px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                       value="<?php echo htmlspecialchars($currency['exchange_rate']); ?>"
                                       placeholder="سعر الصرف">
                                <i class="fas fa-exchange-alt" style="position: absolute; left: 10px; top: 50%; transform: translateY(-50%); color: #7f8c8d; font-size: 14px;"></i>
                            </div>
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> سعر الصرف مقابل العملة المحلية (يجب أن يكون أكبر من صفر)
                            </small>
                        </div>
                    </div>
                </div>

                <!-- الإعدادات الإضافية -->
                <div class="form-section" style="margin-bottom: 30px;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #27ae60; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-cog" style="margin-left: 8px; color: #27ae60;"></i>
                            الإعدادات الإضافية
                        </h3>
                    </div>
                    
                    <div class="form-group" style="padding: 15px; background: #f8f9fa; border: 1px solid #ecf0f1;">
                        <div style="display: flex; align-items: flex-start;">
                            <div style="margin-left: 10px;">
                                <input type="checkbox" name="is_default" id="is_default" value="1" 
                                       style="transform: scale(1.2); margin-top: 3px;"
                                       <?php echo $currency['is_default'] ? 'checked' : ''; ?>
                                       onchange="toggleDefaultWarning(this)">
                            </div>
                            <div>
                                <label class="form-label" for="is_default" style="display: block; margin-bottom: 5px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                    جعلها العملة الافتراضية
                                </label>
                                <div style="color: #7f8c8d; font-size: 13px; margin-bottom: 10px;">
                                    إذا تم تحديدها، سيتم إلغاء العملة الافتراضية الحالية وتعيين هذه العملة كافتراضية للنظام.
                                </div>
                                <?php if ($currency['is_default']): ?>
                                    <div style="padding: 10px; background: #d5f4e6; border: 1px solid #27ae60; color: #27ae60; font-size: 12px; margin-top: 10px;">
                                        <i class="fas fa-check-circle" style="margin-left: 5px;"></i>
                                        <strong>هذه العملة حالياً هي العملة الافتراضية للنظام.</strong>
                                    </div>
                                <?php else: ?>
                                    <div id="defaultWarning" style="display: none; padding: 10px; background: #fff3cd; border: 1px solid #ffeaa7; color: #856404; font-size: 12px; margin-top: 10px;">
                                        <i class="fas fa-exclamation-triangle" style="margin-left: 5px;"></i>
                                        <strong>تنبيه:</strong> سيتم تعيين هذه العملة كعملة افتراضية للنظام، وسيتم إلغاء العملة الافتراضية السابقة.
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- معلومات إضافية -->
                <div class="form-section" style="margin-bottom: 30px; padding: 15px; background: #f8f9fa; border-left: 4px solid #f39c12;">
                    <div style="display: flex; align-items: center; margin-bottom: 10px;">
                        <i class="fas fa-info-circle" style="margin-left: 8px; color: #f39c12;"></i>
                        <h4 style="margin: 0; font-size: 14px; color: #2c3e50; font-weight: 600;">
                            معلومات إضافية:
                        </h4>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 10px; font-size: 12px;">
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #7f8c8d; margin-bottom: 3px;">تاريخ الإنشاء</div>
                            <div style="color: #2c3e50; font-weight: 500;">
                                <?php echo date('Y-m-d', strtotime($currency['created_at'])); ?>
                            </div>
                        </div>
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #7f8c8d; margin-bottom: 3px;">آخر تحديث</div>
                            <div style="color: #2c3e50; font-weight: 500;">
                                <?php echo !empty($currency['updated_at']) ? date('Y-m-d', strtotime($currency['updated_at'])) : 'لم يتم التحديث'; ?>
                            </div>
                        </div>
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #7f8c8d; margin-bottom: 3px;">الحالة</div>
                            <div style="color: <?php echo $currency['is_default'] ? '#27ae60' : '#3498db'; ?>; font-weight: 600;">
                                <?php echo $currency['is_default'] ? 'افتراضية' : 'غير افتراضية'; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer Buttons -->
            <div style="background: #f8f9fa; padding: 15px 25px; border-top: 1px solid #ecf0f1; display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 12px; color: #7f8c8d;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 5px;"></i>
                    الحقول المميزة بـ <span style="color: #e74c3c;">*</span> إجبارية
                </div>
                
                <div style="display: flex; gap: 10px;">
                    <a href="currencies.php" class="btn" 
                       style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                       onmouseover="this.style.background='#7f8c8d'"
                       onmouseout="this.style.background='#95a5a6'">
                        <i class="fas fa-times" style="margin-left: 8px;"></i>
                        إلغاء
                    </a>
                    <button type="submit" class="btn" 
                            style="padding: 8px 25px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                            onmouseover="this.style.background='#27ae60'"
                            onmouseout="this.style.background='#2ecc71'">
                        <i class="fas fa-save" style="margin-left: 8px;"></i>
                        تحديث البيانات
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .form-control:focus {
        outline: none;
    }
    
    .alert-error {
        display: none;
    }
    
    /* Additional styling for better visual */
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-label {
        display: block;
        margin-bottom: 8px;
        color: #2c3e50;
        font-weight: 500;
        font-size: 14px;
    }
</style>

<script>
function showLoader() {
    // Validate form first
    if (validateForm()) {
        document.getElementById('loadingOverlay').style.display = 'flex';
        return true;
    }
    return false;
}

function validateForm() {
    const nameField = document.getElementById('name');
    const codeField = document.getElementById('code');
    const exchangeRateField = document.getElementById('exchange_rate');
    let isValid = true;
    
    // Reset styles
    nameField.style.borderColor = '#bdc3c7';
    nameField.style.boxShadow = 'none';
    codeField.style.borderColor = '#bdc3c7';
    codeField.style.boxShadow = 'none';
    exchangeRateField.style.borderColor = '#bdc3c7';
    exchangeRateField.style.boxShadow = 'none';
    
    // Validate name
    if (!nameField.value.trim()) {
        nameField.style.borderColor = '#e74c3c';
        nameField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    }
    
    // Validate code (exactly 3 characters)
    if (!codeField.value.trim()) {
        codeField.style.borderColor = '#e74c3c';
        codeField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    } else if (codeField.value.trim().length !== 3) {
        codeField.style.borderColor = '#e74c3c';
        codeField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        alert('رمز العملة يجب أن يتكون من 3 أحرف بالضبط');
        isValid = false;
    }
    
    // Validate exchange rate
    const exchangeRate = parseFloat(exchangeRateField.value);
    if (!exchangeRateField.value.trim() || isNaN(exchangeRate) || exchangeRate <= 0) {
        exchangeRateField.style.borderColor = '#e74c3c';
        exchangeRateField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        alert('سعر الصرف يجب أن يكون رقماً أكبر من الصفر');
        isValid = false;
    }
    
    if (!isValid) {
        alert('الرجاء تعبئة الحقول الإجبارية بشكل صحيح');
        return false;
    }
    
    return true;
}

// Auto-format code field to uppercase and limit to 3 characters
document.getElementById('code').addEventListener('input', function(e) {
    this.value = this.value.toUpperCase().replace(/[^A-Z]/g, '').substring(0, 3);
});

// Toggle warning for default currency
function toggleDefaultWarning(checkbox) {
    const warningDiv = document.getElementById('defaultWarning');
    if (warningDiv) {
        if (checkbox.checked) {
            warningDiv.style.display = 'block';
        } else {
            warningDiv.style.display = 'none';
        }
    }
}

// Add input event listeners to clear error styles
document.querySelectorAll('.form-control').forEach(field => {
    field.addEventListener('input', function() {
        if (this.value.trim()) {
            this.style.borderColor = '#bdc3c7';
            this.style.boxShadow = 'none';
        }
    });
});

// Show loader if page is taking time to submit (fallback)
setTimeout(() => {
    const loader = document.getElementById('loadingOverlay');
    if (loader && loader.style.display === 'flex') {
        const messages = loader.querySelectorAll('div');
        if (messages.length >= 2) {
            messages[1].textContent = 'لا يزال جاري معالجة البيانات...';
            messages[2].textContent = 'قد تستغرق العملية وقتاً أطول من المتوقع';
        }
    }
}, 5000);
</script>

<?php
include 'views/layout/footer.php';
?>