<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0;padding: 8px;  margin: 5px auto; max-width: 1200px;">
 <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;  position: sticky; top: 0;
z-index: 1100;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-building" style="margin-left: 8px;"></i>
                إضافة شركة جديدة
            </h2>
            <div style="font-size: 12px; opacity: 0.8;">
                <span class="badge" style="background: #e67e22; padding: 4px 8px; border-radius: 0;">سجل الموردين</span>
            </div>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <?php if (!empty($error)): ?>
        <div class="alert alert-danger" style="margin: 0; border-radius: 0; border: none; border-bottom: 1px solid #e74c3c; background: #ffe6e6; padding: 12px 20px; display: flex; align-items: center;">
            <i class="fas fa-exclamation-circle" style="margin-left: 10px; color: #e74c3c;"></i>
            <span><?php echo htmlspecialchars($error); ?></span>
        </div>
        <?php endif; ?>

        <!-- Loader Overlay -->
        <div id="loadingOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255,255,255,0.9); z-index: 9999; justify-content: center; align-items: center; flex-direction: column;">
            <div class="loader" style="width: 50px; height: 50px; border: 5px solid #f3f3f3; border-top: 5px solid #e67e22; border-radius: 50%; animation: spin 1s linear infinite; margin-bottom: 20px;"></div>
            <div style="color: #2c3e50; font-size: 16px; font-weight: 500;">جاري حفظ بيانات الشركة...</div>
            <div style="color: #7f8c8d; font-size: 14px; margin-top: 10px;">يرجى الانتظار</div>
        </div>

        <form method="POST" action="" id="companyForm" onsubmit="showLoader()">
            <div style="padding: 25px;">
                <!-- معلومات الشركة الأساسية -->
                <div class="form-section" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #ecf0f1;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #e67e22; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-info-circle" style="margin-left: 8px; color: #e67e22;"></i>
                            المعلومات الأساسية
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="name" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> اسم الشركة
                            </label>
                            <input type="text" class="form-control" id="name" name="name" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; transition: border-color 0.3s;"
                                   onfocus="this.style.borderColor='#e67e22'; this.style.boxShadow='0 0 0 2px rgba(230,126,34,0.2)';"
                                   onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none';"
                                   value="<?php echo htmlspecialchars($_POST['name'] ?? ''); ?>"
                                   placeholder="أدخل اسم الشركة">
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> الاسم الكامل للشركة الموردة
                            </small>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="phone" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                رقم الهاتف
                            </label>
                            <div style="position: relative;">
                                <input type="text" class="form-control" id="phone" name="phone" 
                                       style="width: 100%; padding: 10px 12px 10px 35px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                       value="<?php echo htmlspecialchars($_POST['phone'] ?? ''); ?>"
                                       placeholder="رقم هاتف الشركة">
                                <i class="fas fa-phone" style="position: absolute; left: 10px; top: 50%; transform: translateY(-50%); color: #7f8c8d; font-size: 14px;"></i>
                            </div>
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> رقم التواصل مع الشركة
                            </small>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="address" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                            العنوان
                        </label>
                        <textarea class="form-control" id="address" name="address" rows="3"
                                  style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; resize: vertical; min-height: 80px;"
                                  placeholder="عنوان الشركة..."><?php echo htmlspecialchars($_POST['address'] ?? ''); ?></textarea>
                        <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                            <i class="fas fa-info-circle"></i> العنوان الكامل للشركة
                        </small>
                    </div>
                </div>

                <!-- المعلومات المالية -->
                <div class="form-section" style="margin-bottom: 30px;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #27ae60; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-chart-line" style="margin-left: 8px; color: #27ae60;"></i>
                            المعلومات المالية
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr; gap: 20px; max-width: 400px;">
                        <div class="form-group">
                            <label class="form-label" for="opening_balance" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                الرصيد الافتتاحي
                            </label>
                            <div style="position: relative;">
                                <input type="number" step="0.01" class="form-control" id="opening_balance" name="opening_balance" 
                                       style="width: 100%; padding: 10px 12px 10px 30px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                       value="<?php echo htmlspecialchars($_POST['opening_balance'] ?? '0'); ?>">
                                <span style="position: absolute; left: 10px; top: 50%; transform: translateY(-50%); color: #7f8c8d;">¥</span>
                            </div>
                            <div style="background: #f8f9fa; padding: 10px; margin-top: 10px; border-left: 3px solid #e67e22;">
                                <div style="display: flex; align-items: center; margin-bottom: 5px;">
                                    <i class="fas fa-info-circle" style="margin-left: 8px; color: #e67e22;"></i>
                                    <span style="font-size: 13px; color: #2c3e50;">معلومات الرصيد الافتتاحي:</span>
                                </div>
                                <ul style="margin: 0; padding-right: 15px; font-size: 12px; color: #7f8c8d;">
                                    <li>يُسجل كحركة دائنة في حساب الشركة (مدين للشركة)</li>
                                    <li>القيمة الموجبة تعني أن الشركة مدينة لك (لديك رصيد لها)</li>
                                    <li>القيمة السالبة تعني أنك مدين للشركة (عليك دفع لها)</li>
                                    <li>اترك القيمة صفر إذا لم يكن هناك رصيد افتتاحي</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer Buttons -->
            <div style="background: #f8f9fa; padding: 15px 25px; border-top: 1px solid #ecf0f1; display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 12px; color: #7f8c8d;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 5px;"></i>
                    الحقول المميزة بـ <span style="color: #e74c3c;">*</span> إجبارية
                </div>
                
                <div style="display: flex; gap: 10px;">
                    <a href="companies.php" class="btn" 
                       style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                       onmouseover="this.style.background='#7f8c8d'"
                       onmouseout="this.style.background='#95a5a6'">
                        <i class="fas fa-times" style="margin-left: 8px;"></i>
                        إلغاء
                    </a>
                    <button type="submit" class="btn" 
                            style="padding: 8px 25px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                            onmouseover="this.style.background='#27ae60'"
                            onmouseout="this.style.background='#2ecc71'">
                        <i class="fas fa-save" style="margin-left: 8px;"></i>
                        حفظ الشركة
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .form-control:focus {
        outline: none;
    }
    
    .alert-error {
        display: none;
    }
    
    /* Additional styling for better visual */
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-label {
        display: block;
        margin-bottom: 8px;
        color: #2c3e50;
        font-weight: 500;
        font-size: 14px;
    }
    
    /* Balance indicator */
    .balance-indicator {
        display: flex;
        align-items: center;
        margin-top: 5px;
    }
    
    .balance-status {
        padding: 2px 8px;
        border-radius: 0;
        font-size: 11px;
        margin-right: 8px;
    }
    
    .balance-positive {
        background: #d5f4e6;
        color: #27ae60;
        border: 1px solid #27ae60;
    }
    
    .balance-negative {
        background: #fadbd8;
        color: #e74c3c;
        border: 1px solid #e74c3c;
    }
    
    .balance-zero {
        background: #f2f3f4;
        color: #7f8c8d;
        border: 1px solid #bdc3c7;
    }
</style>

<script>
function showLoader() {
    // Validate form first
    if (validateForm()) {
        document.getElementById('loadingOverlay').style.display = 'flex';
        return true;
    }
    return false;
}

function validateForm() {
    const nameField = document.getElementById('name');
    const phoneField = document.getElementById('phone');
    let isValid = true;
    
    // Reset styles
    nameField.style.borderColor = '#bdc3c7';
    nameField.style.boxShadow = 'none';
    phoneField.style.borderColor = '#bdc3c7';
    phoneField.style.boxShadow = 'none';
    
    // Validate name
    if (!nameField.value.trim()) {
        nameField.style.borderColor = '#e74c3c';
        nameField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    }
    
    // Validate phone format (optional but if provided, check format)
    if (phoneField.value.trim() && !/^[\d\s\-\+\(\)]{8,}$/.test(phoneField.value)) {
        phoneField.style.borderColor = '#e74c3c';
        phoneField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        alert('يرجى إدخال رقم هاتف صحيح');
        isValid = false;
    }
    
    if (!isValid) {
        alert('الرجاء تعبئة الحقول الإجبارية بشكل صحيح');
        return false;
    }
    
    return true;
}

// Format phone number as user types
document.getElementById('phone').addEventListener('input', function(e) {
    // السماح بالأرقام فقط (0-9) وبعض الرموز مثل + - ()
    e.target.value = e.target.value.replace(/[^\d+\-() ]/g, '');
});


// Add input event listeners to clear error styles
document.querySelectorAll('.form-control').forEach(field => {
    field.addEventListener('input', function() {
        if (this.value.trim()) {
            this.style.borderColor = '#bdc3c7';
            this.style.boxShadow = 'none';
        }
    });
});

// Update balance indicator based on opening balance value
document.getElementById('opening_balance').addEventListener('input', function(e) {
    const value = parseFloat(e.target.value) || 0;
    const balanceIndicator = document.getElementById('balanceIndicator');
    
    if (!balanceIndicator) {
        const indicatorContainer = document.createElement('div');
        indicatorContainer.className = 'balance-indicator';
        indicatorContainer.id = 'balanceIndicator';
        
        const statusSpan = document.createElement('span');
        statusSpan.className = 'balance-status';
        
        const textSpan = document.createElement('span');
        textSpan.style.fontSize = '12px';
        textSpan.style.color = '#7f8c8d';
        
        indicatorContainer.appendChild(statusSpan);
        indicatorContainer.appendChild(textSpan);
        
        this.parentNode.parentNode.appendChild(indicatorContainer);
    }
    
    const statusSpan = document.querySelector('#balanceIndicator .balance-status');
    const textSpan = document.querySelector('#balanceIndicator span:last-child');
    
    if (value > 0) {
        statusSpan.className = 'balance-status balance-positive';
        statusSpan.textContent = 'مدين';
        textSpan.textContent = 'الشركة مدينة لك (لديك رصيد لها)';
    } else if (value < 0) {
        statusSpan.className = 'balance-status balance-negative';
        statusSpan.textContent = 'دائن';
        textSpan.textContent = 'أنت مدين للشركة (عليك دفع لها)';
    } else {
        statusSpan.className = 'balance-status balance-zero';
        statusSpan.textContent = 'صفر';
        textSpan.textContent = 'لا يوجد رصيد افتتاحي';
    }
});

// Initialize balance indicator on page load
document.addEventListener('DOMContentLoaded', function() {
    const openingBalance = document.getElementById('opening_balance');
    if (openingBalance.value !== '0') {
        const event = new Event('input');
        openingBalance.dispatchEvent(event);
    }
});

// Show loader if page is taking time to submit (fallback)
setTimeout(() => {
    const loader = document.getElementById('loadingOverlay');
    if (loader && loader.style.display === 'flex') {
        const messages = loader.querySelectorAll('div');
        if (messages.length >= 2) {
            messages[1].textContent = 'لا يزال جاري معالجة البيانات...';
            messages[2].textContent = 'قد تستغرق العملية وقتاً أطول من المتوقع';
        }
    }
}, 5000);
</script>

<?php
include 'views/layout/footer.php';
?>