<?php
require_once 'InvoiceManager.php';

class InvoiceUpdater extends InvoiceManager {
    
    // تحديث الفاتورة
    public function updateInvoice($invoiceId, $data) {
        try {
            $this->db->beginTransaction();
            
            // تسجيل القيم القديمة للت audit
            $oldInvoice = $this->getInvoice($invoiceId);
            
            $stmt = $this->db->prepare("
                UPDATE invoices 
                SET customer_id = ?, currency_id = ?, exchange_rate = ?,
                    office_commission = ?, shipping_costs = ?, certificate_costs = ?,
                    updated_at = CURRENT_TIMESTAMP
                WHERE id = ?
            ");
            
            $stmt->execute([
                $data['customer_id'],
                $data['currency_id'],
                $data['exchange_rate'],
                $data['office_commission'],
                $data['shipping_costs'],
                $data['certificate_costs'],
                $invoiceId
            ]);
            
            // تحديث الإجمالي
            $this->updateInvoiceTotal($invoiceId);
            
            // تسجيل في سجل التغييرات
            $this->logInvoiceChange($invoiceId, 'update', $oldInvoice, $data);
            
            $this->db->commit();
            return true;
            
        } catch(Exception $e) {
            $this->db->rollBack();
            throw $e;
        }
    }
    
    // حذف صنف من الفاتورة
    public function deleteInvoiceItem($itemId) {
        try {
            $this->db->beginTransaction();
            
            // الحصول على بيانات الصنف قبل الحذف
            $stmt = $this->db->prepare("SELECT invoice_id, company_id, total_price FROM invoice_items WHERE id = ?");
            $stmt->execute([$itemId]);
            $item = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // حذف الصنف
            $stmt = $this->db->prepare("DELETE FROM invoice_items WHERE id = ?");
            $stmt->execute([$itemId]);
            
            // إذا كان للصنف شركة موردة، نعكس القيد المحاسبي
            if ($item['company_id']) {
                $this->reverseCompanyTransaction($item['invoice_id'], $item['company_id'], $item['total_price']);
            }
            
            // تحديث إجمالي الفاتورة
            $this->updateInvoiceTotal($item['invoice_id']);
            
            $this->db->commit();
            return true;
            
        } catch(Exception $e) {
            $this->db->rollBack();
            throw $e;
        }
    }
    
    // عكس حركة الشركة الموردة
    private function reverseCompanyTransaction($invoiceId, $companyId, $amount) {
        $stmt = $this->db->prepare("
            INSERT INTO transactions (
                date, account_type, account_id, related_invoice_id,
                debit_amount, description, balance_after
            ) VALUES (CURDATE(), 'company', ?, ?, ?, ?, 
                (SELECT current_balance FROM companies WHERE id = ?) - ?)
        ");
        
        $description = "إلغاء مستحق من فاتورة #$invoiceId";
        $stmt->execute([$companyId, $invoiceId, $amount, $description, $companyId, $amount]);
        
        // تحديث رصيد الشركة
        $stmt = $this->db->prepare("
            UPDATE companies SET current_balance = current_balance - ? WHERE id = ?
        ");
        $stmt->execute([$amount, $companyId]);
    }
    
    // تسجيل تغييرات الفاتورة
    private function logInvoiceChange($invoiceId, $action, $oldValues, $newValues) {
        $stmt = $this->db->prepare("
            INSERT INTO invoice_audit (invoice_id, action, old_values, new_values, changed_by)
            VALUES (?, ?, ?, ?, ?)
        ");
        
        $stmt->execute([
            $invoiceId,
            $action,
            json_encode($oldValues),
            json_encode($newValues),
            $_SESSION['user_id']
        ]);
    }
}
?>