<?php
require_once 'config.php';
$db = Config::getDB();

function format_currency($amount, $symbol) {
    return number_format($amount, 2) . ' ' . htmlspecialchars($symbol);
}

/* =======================
   دالة تحويل رقم إلى كلمات
======================= */
function numberToWords($number) {
    $hyphen = '-';
    $conjunction = ' and ';
    $separator = ', ';
    $negative = 'negative ';
    $dictionary = [
        0 => 'zero',
        1 => 'one',
        2 => 'two',
        3 => 'three',
        4 => 'four',
        5 => 'five',
        6 => 'six',
        7 => 'seven',
        8 => 'eight',
        9 => 'nine',
        10 => 'ten',
        11 => 'eleven',
        12 => 'twelve',
        13 => 'thirteen',
        14 => 'fourteen',
        15 => 'fifteen',
        16 => 'sixteen',
        17 => 'seventeen',
        18 => 'eighteen',
        19 => 'nineteen',
        20 => 'twenty',
        30 => 'thirty',
        40 => 'forty',
        50 => 'fifty',
        60 => 'sixty',
        70 => 'seventy',
        80 => 'eighty',
        90 => 'ninety',
        100 => 'hundred',
        1000 => 'thousand'
    ];

    if (!is_numeric($number)) return false;
    if ($number < 0) return $negative . numberToWords(abs($number));

    $string = '';
    if ($number < 21) {
        $string = $dictionary[$number];
    } elseif ($number < 100) {
        $tens = ((int) ($number / 10)) * 10;
        $units = $number % 10;
        $string = $dictionary[$tens];
        if ($units) {
            $string .= $hyphen . $dictionary[$units];
        }
    } elseif ($number < 1000) {
        $hundreds = (int) ($number / 100);
        $remainder = $number % 100;
        $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
        if ($remainder) {
            $string .= $conjunction . numberToWords($remainder);
        }
    } else {
        $thousands = (int) ($number / 1000);
        $remainder = $number % 1000;
        $string = numberToWords($thousands) . ' ' . $dictionary[1000];
        if ($remainder) {
            if ($remainder < 100) $string .= $conjunction;
            else $string .= $separator;
            $string .= numberToWords($remainder);
        }
    }
    return $string;
}

/* =======================
      جلب رقم الفاتورة
======================= */

$invoice_id = $_GET['invoice_id'] ?? null;  // قيمة ثابتة 2 إن لم يوجد GET

if (!$invoice_id) {
    die('رقم الفاتورة مطلوب');
}
$currency_id = $_GET['currency_id'] ?? null;

if (!$currency_id) {
    die('العملة المختارة مطلوبة');
}
/* =======================
     جلب بيانات الفاتورة
======================= */

$stmt = $db->prepare("
    SELECT i.*, 
           c.name AS customer_name,
        
           c.phone AS customer_phone,
           c.address AS customer_address,
           cur.code AS currency_code,
           cur.name AS currency_name
    FROM invoices i
    JOIN customers c ON i.customer_id = c.id
    JOIN currencies cur ON i.currency_id = cur.id
    WHERE i.id = :id
");
$stmt->execute([':id' => $invoice_id]);

$invoice = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$invoice) {
    die('الفاتورة غير موجودة');
}

/* =======================
   جلب سعر الصرف للفاتورة
======================= */
$stmt_rate = $db->prepare("
    SELECT 
        ier.exchange_rate,
        cur.code,
        cur.name,
        cur.symbol
    FROM invoice_exchange_rates ier
    JOIN currencies cur ON ier.currency_id = cur.id
    WHERE ier.invoice_id = :invoice_id
      AND ier.currency_id = :currency_id
    LIMIT 1
");

$stmt_rate->execute([
    ':invoice_id' => $invoice_id,
    ':currency_id' => $currency_id
]);

$exchange = $stmt_rate->fetch(PDO::FETCH_ASSOC);

if (!$exchange) {
    die('لا يوجد سعر صرف مقيد لهذه الفاتورة مع العملة المختارة');
}

$exchange_rate   = (float)$exchange['exchange_rate'];
$print_currency  = $exchange['code'];
$currency_name   = $exchange['name'];
$currency_symbol = $exchange['symbol'];

/* =======================
      جلب عناصر الفاتورة
======================= */

$stmt_items = $db->prepare("
    SELECT ii.*, 
           it.name AS item_name,
           it.model AS item_model,
           it.specifications AS item_specifications,
           ii.unit_price AS quoted_price_per_unit,
           it.image AS item_image,
           comp.name AS company_name,
           u.code AS unit_name,
           ct.total_cartons AS ctn_value,
           w.total_weight AS weight_value,
           cb.total_cbm AS cbm_value
    FROM invoice_items ii
    JOIN items it ON ii.item_id = it.id
    LEFT JOIN companies comp ON ii.company_id = comp.id
    LEFT JOIN units u ON it.unit_id = u.id
    LEFT JOIN shared_cartons ct ON ii.carton_id = ct.id
    LEFT JOIN shared_weights w ON ii.weight_id = w.id
    LEFT JOIN shared_cbm cb ON ii.cbm_id = cb.id
    WHERE ii.invoice_id = :invoice_id
    ORDER BY ii.created_at
");
$stmt_items->execute([':invoice_id' => $invoice_id]);

$invoice_items = $stmt_items->fetchAll(PDO::FETCH_ASSOC);

if (!$invoice_items) {
    die('لا توجد عناصر في هذه الفاتورة');
}

/* =======================
        حساب الإجماليات
======================= */

$total_quantity = 0;
$total_ctn = 0;
$total_weight = 0;
$total_cbm = 0;

$unique_items_for_totals = [];

foreach ($invoice_items as $item) {

    // الكمية
    $total_quantity += (float)$item['quantity'];

    // الكرتون
    if (!empty($item['carton_id'])) {
        $key = "ctn_" . $item['carton_id'];
        if (!isset($unique_items_for_totals[$key])) {
            $total_ctn += (float)$item['ctn_value'];
            $unique_items_for_totals[$key] = true;
        }
    }

    // الوزن
    if (!empty($item['weight_id'])) {
        $key = "weight_" . $item['weight_id'];
        if (!isset($unique_items_for_totals[$key])) {
            $total_weight += (float)$item['weight_value'];
            $unique_items_for_totals[$key] = true;
        }
    }

    // CBM
    if (!empty($item['cbm_id'])) {
        $key = "cbm_" . $item['cbm_id'];
        if (!isset($unique_items_for_totals[$key])) {
            $total_cbm += (float)$item['cbm_value'];
            $unique_items_for_totals[$key] = true;
        }
    }
}

/* =======================
   تجهيز تكرار دمج الخلايا
======================= */

$ctn_counts = [];
$weight_counts = [];
$cbm_counts = [];

foreach ($invoice_items as $item) {

    if (!empty($item['carton_id'])) {
        if (!isset($ctn_counts[$item['carton_id']])) $ctn_counts[$item['carton_id']] = 0;
        $ctn_counts[$item['carton_id']]++;
    }

    if (!empty($item['weight_id'])) {
        if (!isset($weight_counts[$item['weight_id']])) $weight_counts[$item['weight_id']] = 0;
        $weight_counts[$item['weight_id']]++;
    }

    if (!empty($item['cbm_id'])) {
        if (!isset($cbm_counts[$item['cbm_id']])) $cbm_counts[$item['cbm_id']] = 0;
        $cbm_counts[$item['cbm_id']]++;
    }
}

?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> فاتورة #<?php echo $invoice['invoice_number']; ?></title>
    <link rel="stylesheet" href="fontawesome-free-6.7.2-web/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    
    <style>
    body {
        font-family: 'Times New Roman', serif;
        background-color: #f8f9fa;
    }

    .invoice-container {
        max-width: 850px;
        margin: 0 auto;
        background: white;
        box-shadow: 0 0 20px rgba(0,0,0,0.1);
    }

    .invoice-header {
        background: linear-gradient(135deg, #0E4262 0%, #F19E2C 100%);
        color: white;
        padding: 10px;
        text-align: center;
    }

    .invoice-body {
        padding: 16px;
    }

    .company-info {
        text-align: center;
        margin-bottom: 5px;
        padding: 10px;
        background-color: #f8f9fa;
        border-radius: 10px;
    }

    .customer-info {
        background-color: #f8f9fa;
        padding: 5px;
        border-radius: 10px;
        margin-bottom: 10px;
    }

    .table th, .table td {
        border: 1px solid #d3d3d3 !important;
    }

    .table thead th {
        padding: 4px 6px !important;
        font-size: 12px;
    }

    .table tbody tr {
        border: 1px solid #d3d3d3 !important;
    }

    .table thead th:nth-child(odd) {
        background-color: #eaa033 !important;
        color: white !important;
    }
    
    .table thead th:nth-child(even) {
        background-color: #22445d !important;
        color: white !important;
    }

    .total-section {
        background-color: #f8f9fa;
        padding: 20px;
        border-radius: 10px;
        margin-top: 20px;
    }

    .invoice-footer {
        background-color: #f8f9fa;
        padding: 20px;
        text-align: center;
        border-top: 1px solid #dee2e6;
    }

    @media print {
        .no-print {
            display: none !important;
        }
        
        @page {
            margin-top: 1px;
            margin-bottom: 5px;
            margin-left: 0 !important;
            margin-right: 0 !important;
            padding: 0px !important;
        }
        
        thead, tfoot {
            display: table-row-group !important;
        }
        
        tr, td, th {
            page-break-inside: auto !important;
        }
        
        table {
            page-break-inside: auto !important;
        }
        
        body {
            background-color: white;
            margin-top: 1px;
            margin-bottom: 5px;
            margin-left: 0 !important;
            margin-right: 0 !important;
            padding: 3px !important;
                 -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
        }
        
        .invoice-container {
            box-shadow: none;
        }
    }
    
    .stamp-container {
        position: relative;
        margin-top: 20px;
        text-align: center;
    }

    .stamp-over-total {
        position: absolute;
        right: 20%;
        transform: translateX(50%);
        top: -18px;
        opacity: 0.9;
        width: 150px;
        z-index: 100;
    }

    .no-print {
        text-align: center;
        margin-bottom: 10px;
    }

    .no-print button {
        color: white;
        border: none;
        padding: 10px 13px;
        border-radius: 8px;
        font-size: 18px;
        margin: 4px;
        cursor: pointer;
        transition: all 0.25s ease-in-out;
    }

    .no-print button.print-btn { background: #34416E; }
    .no-print button.whatsapp-btn { background: #25D366; }
    .no-print button.close-btn { background: #dc3545; }

    .no-print button.print-btn:hover { background: #465493; transform: scale(1.1); }
    .no-print button.whatsapp-btn:hover { background: #2fe97a; transform: scale(1.1); }
    .no-print button.close-btn:hover { background: #e64a59; transform: scale(1.1); }

    .no-print button:hover {
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }

    .watermark {
    position: absolute;
    top: 450px; /* حرّك للأعلى أو الأسفل */
    left: 50%;
    transform: translateX(-50%);
    width: 550px;   /* حجم اللوجو */
    height: 350px;
    background-image: url('logo_water.png'); /* ضع صورة اللوجو */
    background-size: contain;
    background-repeat: no-repeat;
    opacity: 5.07; /* درجة الشفافية */
    z-index: 0;
    pointer-events: none;
}

    </style>
</head>
<body>
    <div class="container-fluid py-4" id="invoice-container">
        <div class="invoice-container">
            <!-- Header -->
            <div class="company-info" style="padding:0; margin-bottom:10px; background:none;">
                <img src="logo2.png" alt="Company Logo" style="width:100%; height:auto; display:block;">

                <div style="text-align:center; margin-top:0; font-size:12px; direction:ltr;">
                    <p style="margin-bottom:2px;">
                        <img src="phone.png" alt="contact" style="height:50px;">
                    </p>
                </div>

                <div style="height:2px; width:80%; background:#22445d; margin:3px 0 3px 20px; float:left;"></div>
                <div style="clear:both;"></div>
            </div>

            <!-- Body -->
            <div class="invoice-body">
                <!-- Customer Info -->
                <div class="customer-info" style="padding:6px; border-radius:4px; margin:-16px 0 10px 0; font-size:12px; font-weight:bold;">

    <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:4px;">

        <!-- Invoice NO يسار -->
        <span style="background:#eaa033; padding:1px 10px; color:#fff;">
            Invoice NO: <?php echo htmlspecialchars($invoice['invoice_number']); ?>
        </span>

        <!-- INVOICE بالمنتصف -->
        <span style="font-size:15px; font-weight:bold;">
           SHIPPING INVOICE
        </span>

        <!-- To يمين -->
        <span style="background:#eaa033; padding:1px 10px; color:#fff;">
            To: <?php echo htmlspecialchars($invoice['customer_name']); ?>
        </span>

    </div>

    <div style="display:flex; justify-content:space-between;">
        <span>
            Date: <?php echo date('Y-m-d', strtotime($invoice['created_at'])); ?>
        </span>
        <div></div>
    </div>

</div>


                <!-- Invoice Items -->
                <?php
                $ctn_printed = [];
                $weight_printed = [];
                $cbm_printed = [];
                ?>

                <!-- خلفية لوجو مائي -->
                <div class="watermark"></div>

                <div class="table-responsive">
                    <table class="table table-bordered" style="direction: ltr;">
                        <colgroup>
                             <col style="width: 4%;">
                            <col style="width: 12%;">
                            <col style="width: 22%;">
                            <col style="width: 24%;">
                            <col style="width: 12%;">
                            <col style="width: 7%;">
                            <col style="width: 7%;">
                            <col style="width: 12%;">
                        </colgroup>
                        
                        <thead>
                            <tr>
                                <th style="color:black; font-size:12px; text-align:center;">No.</th>
                                <th style="color:black; font-size:12px; text-align:center;">Model No.</th>
                                <th style="color:black; font-size:12px; text-align:center;">Name</th>
                                <th style="color:black; font-size:12px; text-align:center;">Specification</th>
                                <th style="background:yellow; color:black; font-size:12px; text-align:center;">Price</th>
                                <th colspan="2" style="background:yellow; color:black; font-size:12px; text-align:center;">Quantity</th>
                                <th style="background:yellow; color:black; font-size:12px; text-align:center;">Total</th>
                                
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $counter = 1;
                            $grand_total = 0; 
                            ?>
                           <?php foreach ($invoice_items as $item): ?>

<?php
    // سعر الوحدة بعد التحويل
    $converted_price = $item['quoted_price_per_unit'] * $exchange_rate;

    // إجمالي الصنف
    $item_total = $item['quantity'] * $converted_price;

    // تجميع الإجمالي العام
    $grand_total += $item_total;
?>

<tr>
    <td style="text-align:center; font-size:12px"><?php echo $counter++; ?></td>
    <td style="text-align:center; font-size:10px"><?php echo htmlspecialchars($item['item_model']); ?></td>
    <td style="text-align:center;font-weight:bold; font-size:12px"><?php echo htmlspecialchars($item['item_name']); ?></td>

  

    <td style="text-align:left; font-size:11px">
        <?php echo nl2br(htmlspecialchars($item['item_specifications'])); ?>
    </td>

    <!-- سعر الوحدة -->
    <td style="text-align:center; font-size:12px;">
        <?= format_currency($converted_price, $currency_symbol); ?>
    </td>

    <!-- الكمية -->
    <td style="text-align:center; font-size:12px;">
        <?= number_format($item['quantity']); ?>
    </td>

    <td style="text-align:center; font-size:12px; border-left:1px solid #000;">
        <?= htmlspecialchars($item['unit_name']); ?>
    </td>

    <!-- إجمالي الصنف -->
    <td style="text-align:center; font-size:12px;">
        <?= format_currency($item_total, $currency_symbol); ?>
    </td>
</tr>

<?php endforeach; ?>

<?php
/* =======================
   حساب الإجماليات النهائية
======================= */

$commission_percent = (float)($invoice['office_commission'] ?? 0);
$commission_value   = ($grand_total * $commission_percent) / 100;

$certificates_cost  = ((float)($invoice['certificate_costs'] ?? 0)) * $exchange_rate;

$final_total = $grand_total + $commission_value + $certificates_cost;
?>
                <tfoot>

<tr style="background-color:#f8f9fa; font-weight:bold;">
        <td colspan="7" style="text-align:center; color:#22445d;">Total</td>
       <th  style="text-align:center; color:#eaa033; background:#f0f0f0; font-size: 12px;">
        <?= format_currency($grand_total, $currency_symbol); ?>
    </th>
</tr>


<?php if ((float)$commission_value > 0): ?>
<tr style="background-color:#f8f9fa; font-weight:bold;">
    <td colspan="7" style="text-align:center; color:#22445d;  font-size: 12px;">
        Comission ‘‘ <?= $commission_percent ?>% ’’
    </td>
    <th style="text-align:center; color:#eaa033; background:#f0f0f0; font-size: 12px;">
        <?= format_currency($commission_value, $currency_symbol); ?>
    </th>
</tr>
<?php endif; ?>

<?php if ((float)$certificates_cost > 0): ?>
<tr style="background-color:#f8f9fa; font-weight:bold;">
    <td colspan="7" style="text-align:center; color:#22445d;  font-size: 12px;">
        Certificates-cost
    </td>
    <th style="text-align:center; color:#eaa033; background:#f0f0f0; font-size: 12px;">
        <?= format_currency($certificates_cost, $currency_symbol); ?>
    </th>
</tr>
<?php endif; ?>

<?php 
// Total يظهر فقط إذا كان أحد الصفوف أعلاه >0
if ((float)$commission_value > 0 || (float)$certificates_cost > 0): 
?>
<tr style="background-color:#f8f9fa; font-weight:bold;">
    <td colspan="7" style="text-align:center; color:#22445d;">Total</td>
    <th style="text-align:center; color:#eaa033; background:#f0f0f0; font-size: 12px;">
        <?= format_currency($final_total, $currency_symbol); ?>
    </th>
</tr>
<?php endif; ?>

<?php
$currency_map = [
    'الرينمنبي' => 'Chinese Yuan',
    'الدولار الأمريكي'     => 'US Dollar',
    'الريال السعودي'      => 'Saudi Riyal'
];

$currency_en = $currency_map[$currency_name] ?? $currency_name;
?>

<tr>
    <th colspan="10" style="text-align:center; color:#eaa033;">
    <?= htmlspecialchars($currency_en); ?>
    <?= ucfirst(numberToWords((int)$final_total)); ?> Only
</th>

</tr>

</tfoot>


                    </table>
                         <!-- Notes -->
           <div class="mt-4" style="direction: ltr;">
    <h5 style="font-size:13px; font-weight:bold; margin-bottom:3px;">Remark:</h5>
    <p style="font-size:12px; margin-bottom:2px;">1. Price term: EXW, not including any freight or other cost</p>
    <p style="font-size:12px;">2. Delivery time: 25-30 workdays against 30% deposit</p>
</div>


<!-- Remitting Route -->
<div class="mt-3" style="direction:ltr; display:flex; justify-content:space-between; align-items:flex-start;">
    <div style="max-width:70%;">
        <h5 style="font-size:13px; font-weight:bold; margin-bottom:5px;">
            REMITTING ROUTE FOR USD (美元汇款路线)
        </h5>

        <p style="font-size:12px; margin-bottom:4px;">
            <strong>Intermediary Bank:</strong><br>
            JPMORGAN CHASE BANK, N.A. NEW YORK<br>
            <span style="font-size:11px;">(中间行 54/56A)</span><br>
            <strong>SWIFT BIC:</strong> CHASUS33XXX
        </p>

        <p style="font-size:12px; margin-bottom:4px;">
            <strong>Beneficiary’s Bank:</strong><br>
            ZHEJIANG CHOUZHOU COMMERCIAL BANK CO., LTD.<br>
            <strong>SWIFT BIC:</strong> CZCBCN2X
        </p>

        <p style="font-size:12px; margin-bottom:2px;">
            <strong>Beneficiary:</strong> TWO STARS EQUIPMENT AND TRADE CO., LIMITED
        </p>

        <p style="font-size:12px; margin-bottom:2px;">
            <strong>Account Number:</strong> NRA15622142010500005063
        </p>

        <p style="font-size:12px;">
            <strong>Account Address:</strong><br>
            ZONE 2, INTERNATIONAL TRADE CITY, NO. 1180,<br>
            NORTH CHONGZHOU ROAD, YIWU CITY,<br>
            JINHUA, ZHEJIANG PROVIANCE, CHINA
        </p>
    </div>

    <div style="max-width:25%; text-align:right;">
        <img src="stamp.png" alt="Stamp" style="max-width:100%; height:auto;">
    </div>
</div>


                    <div style="width:100%; margin-top:1px;">
                        <img src="stylefoot.png" alt="Footer Shape" style="width:100%; height:auto; display:block;">
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Buttons -->
        <div class="no-print">
            <button class="print-btn" onclick="window.print()">
                      <i class="fa-solid fa-floppy-disk"></i>
            </button>

         

           <button class="close-btn" onclick="window.close()">

                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>
    </div>
    
    <script>
        async function shareAsPDF() {
            const buttons = document.querySelectorAll('.no-print');
            buttons.forEach(btn => btn.style.display = 'none');

            const { jsPDF } = window.jspdf;
            const invoiceElement = document.getElementById('invoice-container');

            if (!invoiceElement) {
                alert("❌ لم يتم العثور على عنصر الفاتورة");
                buttons.forEach(btn => btn.style.display = 'block');
                return;
            }

            try {
                const canvas = await html2canvas(invoiceElement, {
                    scale: 2,
                    useCORS: true,
                    backgroundColor: '#ffffff'
                });

                const imgData = canvas.toDataURL('image/jpeg', 0.9);
                const pdf = new jsPDF('p', 'mm', 'letter');

                const pageWidth = pdf.internal.pageSize.getWidth();
                const pageHeight = pdf.internal.pageSize.getHeight();
                const imgWidth = pageWidth;
                const imgHeight = (canvas.height * imgWidth) / canvas.width;

                let heightLeft = imgHeight;
                let position = 0;

                while (heightLeft > 0) {
                    pdf.addImage(imgData, 'JPEG', 0, position, imgWidth, imgHeight);
                    heightLeft -= pageHeight;
                    if (heightLeft > 0) {
                        pdf.addPage();
                        position = 0;
                    }
                }

                const pdfBlob = pdf.output('blob');
                const pdfFile = new File([pdfBlob], "packing_list_<?= $invoice['invoice_number'] ?>.pdf", { type: "application/pdf" });

                if (navigator.canShare && navigator.canShare({ files: [pdfFile] })) {
                    await navigator.share({
                        title: " فاتورة رقم <?= $invoice['invoice_number'] ?>",
                        text: "مرفقة  فاتورة",
                        files: [pdfFile]
                    });
                } else {
                    pdf.save("packing_list_<?= $invoice['invoice_number'] ?>.pdf");
                    alert("✅ تم حفظ ملف PDF بنجاح");
                }

            } catch (error) {
                console.error(error);
                alert("❌ حدث خطأ أثناء إنشاء الفاتورة:\n" + error.message);
            } finally {
                buttons.forEach(btn => btn.style.display = 'block');
            }
        }
    </script>
</body>
</html>