<?php
session_start();
require_once 'InvoiceManager.php';

$invoiceManager = new InvoiceManager();
$message = '';
$error = '';

// جلب جميع الفواتير مع إضافة الاستعلام لأسعار الصرف
$db = Config::getDB();
$invoices = $db->query("
    SELECT i.*, c.name as customer_name, cr.name as currency_name, cr.code as currency_code,
           u.username as created_by_name,
           (SELECT COUNT(*) FROM invoice_items WHERE invoice_id = i.id) as items_count,
           (SELECT COUNT(*) FROM invoice_exchange_rates WHERE invoice_id = i.id) as exchange_rates_count
    FROM invoices i
    LEFT JOIN customers c ON i.customer_id = c.id
    LEFT JOIN currencies cr ON i.currency_id = cr.id
    LEFT JOIN users u ON i.created_by = u.id
    ORDER BY i.created_at DESC
")->fetchAll();

// تحميل معلومات الفاتورة المحددة إذا كان هناك تحديد
$selectedInvoice = null;
$selectedInvoiceId = $_GET['selected_invoice'] ?? null;
if ($selectedInvoiceId) {
    $stmt = $db->prepare("
        SELECT i.*, c.name as customer_name, cr.name as currency_name, cr.code as currency_code,
               u.username as created_by_name
        FROM invoices i
        LEFT JOIN customers c ON i.customer_id = c.id
        LEFT JOIN currencies cr ON i.currency_id = cr.id
        LEFT JOIN users u ON i.created_by = u.id
        WHERE i.id = ?
    ");
    $stmt->execute([$selectedInvoiceId]);
    $selectedInvoice = $stmt->fetch();
}

if (($_GET['action'] ?? '') === 'create') {
    header("Location: create_invoice.php");
    exit;
}

// معالجة حذف الفاتورة إذا طلب
if (($_POST['action'] ?? '') === 'delete_invoice') {
    try {
        if (empty($_POST['invoice_id'])) {
            throw new Exception("معرف الفاتورة مطلوب");
        }
        
        $invoiceId = $_POST['invoice_id'];
        
        // حذف الفاتورة والبيانات المرتبطة بها
        $stmt = $db->prepare("DELETE FROM invoice_items WHERE invoice_id = ?");
        $stmt->execute([$invoiceId]);
        
        $stmt = $db->prepare("DELETE FROM invoice_exchange_rates WHERE invoice_id = ?");
        $stmt->execute([$invoiceId]);
        
        $stmt = $db->prepare("DELETE FROM transactions WHERE related_invoice_id = ?");
        $stmt->execute([$invoiceId]);
        
        $stmt = $db->prepare("DELETE FROM invoices WHERE id = ?");
        $stmt->execute([$invoiceId]);
        
        $_SESSION['message'] = "تم حذف الفاتورة بنجاح";
        header("Location: invoices.php");
        exit;
        
    } catch(Exception $e) {
        $_SESSION['error'] = "خطأ في حذف الفاتورة: " . $e->getMessage();
        header("Location: invoices.php");
        exit;
    }
}

// معالجة تغيير حالة الفاتورة (ترحيل/إلغاء ترحيل)
if (($_POST['action'] ?? '') === 'update_invoice_status') {
    try {
        if (empty($_POST['invoice_id'])) {
            throw new Exception("معرف الفاتورة مطلوب");
        }
        
        $invoiceId = $_POST['invoice_id'];
        $newStatus = $_POST['new_status']; // 'confirmed' أو 'draft'
        
        // التحقق من وجود الفاتورة
        $stmt = $db->prepare("SELECT id FROM invoices WHERE id = ?");
        $stmt->execute([$invoiceId]);
        if (!$stmt->fetch()) {
            throw new Exception("الفاتورة غير موجودة");
        }
        
        // تحديث حالة الفاتورة
        $stmt = $db->prepare("UPDATE invoices SET status = ? WHERE id = ?");
        $stmt->execute([$newStatus, $invoiceId]);
        
        $statusText = ($newStatus === 'confirmed') ? 'مرحلة' : 'غير مرحلة';
        $_SESSION['message'] = "تم تحديث حالة الفاتورة إلى $statusText بنجاح";
        header("Location: invoices.php?selected_invoice=" . $invoiceId);
        exit;
        
    } catch(Exception $e) {
        $_SESSION['error'] = "خطأ في تحديث حالة الفاتورة: " . $e->getMessage();
        header("Location: invoices.php?selected_invoice=" . ($_POST['invoice_id'] ?? ''));
        exit;
    }
}

// استرجاع الرسائل من الجلسة
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}
if (isset($_SESSION['error'])) {
    $error = $_SESSION['error'];
    unset($_SESSION['error']);
}
?>

<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0;padding: 8px;  margin: 5px auto; max-width: 1200px;">
 <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;  position: sticky; top: 0;
z-index: 1100;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-file-invoice" style="margin-left: 8px;"></i>
                إدارة الفواتير
            </h2>
            <?php if ($auth->checkPermission('invoices', 'create')): ?>
                <a href="invoices.php?action=create" class="btn" 
                   style="padding: 8px 16px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                   onmouseover="this.style.background='#27ae60'"
                   onmouseout="this.style.background='#2ecc71'">
                    <i class="fas fa-plus" style="margin-left: 8px;"></i>
                    إنشاء فاتورة جديدة
                </a>
            <?php endif; ?>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <!-- شريط البحث والإحصائيات -->
        <div style="padding: 20px; border-bottom: 1px solid #ecf0f1;">
            <!-- شريط البحث -->
            <form method="GET" action="" style="margin-bottom: 10px;">
                <div style="display: flex; gap: 10px;">
                    <div style="position: relative; flex: 1;">
                        <input type="text" name="search" class="form-control" 
                               placeholder="ابحث برقم الفاتورة أو اسم العميل..." 
                               value="<?php echo htmlspecialchars($search ?? ''); ?>"
                               style="width: 100%; padding: 10px 12px 10px 40px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;">
                        <i class="fas fa-search" style="position: absolute; left: 12px; top: 50%; transform: translateY(-50%); color: #7f8c8d;"></i>
                    </div>
                    <button type="submit" class="btn" 
                            style="padding: 8px 20px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center;">
                        <i class="fas fa-search" style="margin-left: 8px;"></i>
                        بحث
                    </button>
                    <?php if (!empty($search)): ?>
                        <a href="invoices.php" class="btn" 
                           style="padding: 8px 16px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center;">
                            <i class="fas fa-times" style="margin-left: 8px;"></i>
                            إلغاء البحث
                        </a>
                    <?php endif; ?>
                </div>
            </form>

            <!-- الإحصائيات -->
            <?php
            // حساب الإحصائيات
            $totalInvoices = count($invoices);
            $draftCount = 0;
            $confirmedCount = 0;
            $cancelledCount = 0;
            $totalAmount = 0;
            
            foreach($invoices as $invoice) {
                if($invoice['status'] == 'draft') $draftCount++;
                if($invoice['status'] == 'confirmed') $confirmedCount++;
                if($invoice['status'] == 'cancelled') $cancelledCount++;
                $totalAmount += $invoice['total_amount'];
            }
            ?>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px;">
                <div style="background: #e8f6f3; padding: 15px; border-left: 4px solid #1abc9c;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">إجمالي الفواتير</div>
                    <div style="font-size: 24px; font-weight: bold; color: #16a085;"><?php echo number_format($totalInvoices); ?></div>
                </div>
                <div style="background: #fef9e7; padding: 15px; border-left: 4px solid #f1c40f;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">فواتير مرحلة</div>
                    <div style="font-size: 24px; font-weight: bold; color: #f39c12;"><?php echo number_format($confirmedCount); ?></div>
                </div>
                <div style="background: #fdedec; padding: 15px; border-left: 4px solid #e74c3c;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">فواتير غير مرحلة</div>
                    <div style="font-size: 24px; font-weight: bold; color: #c0392b;"><?php echo number_format($draftCount); ?></div>
                </div>
                <div style="background: #e8f4fd; padding: 15px; border-left: 4px solid #3498db;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">إجمالي القيمة</div>
                    <div style="font-size: 24px; font-weight: bold; color: #2980b9;">
                        <?php echo number_format($totalAmount, 2); ?> 
                        <span style="font-size: 14px;">CNY</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- رسائل النجاح والخطأ -->
        <?php if ($message): ?>
            <div style="margin: 10px 12px; padding: 8px 12px; background: #d4edda; color: #155724; border: 1px solid #c3e6cb; border-radius: 0; display: flex; align-items: center; justify-content: space-between;">
                <div style="display: flex; align-items: center;">
                    <i class="fas fa-check-circle" style="margin-left: 8px; color: #28a745;"></i>
                    <?php echo htmlspecialchars($message); ?>
                </div>
                <button onclick="this.parentElement.style.display='none'" style="background: none; border: none; color: #155724; cursor: pointer;">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div style="margin: 15px 20px; padding: 12px 15px; background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; border-radius: 0; display: flex; align-items: center; justify-content: space-between;">
                <div style="display: flex; align-items: center;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 8px; color: #dc3545;"></i>
                    <?php echo htmlspecialchars($error); ?>
                </div>
                <button onclick="this.parentElement.style.display='none'" style="background: none; border: none; color: #721c24; cursor: pointer;">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        <?php endif; ?>
<style>
/* تصغير الأزرار داخل الحاوية */
#actionsContainer .btn {
    padding: 4px 10px !important;
    font-size: 11px !important;
}

#actionsContainer .btn i {
    font-size: 10px !important;
    margin-left: 4px !important;
}

#actionsContainer > div {
    gap: 6px !important;
    padding: 10px !important;
}

/* الإخفاء الافتراضي */
#actionsContainer {
    max-height: 0;
    overflow: hidden;
    transition: max-height 0.3s ease;
}

/* عند تفعيل الإظهار (مثلاً عند النقر) */
#actionsContainer.show {
  max-height: 500px; /* أو أي قيمة مناسبة لتظهر كل الأزرار */
}
</style>
        <!-- حاوية أزرار الإجراءات (ستظهر عند التحديد) -->
      <div id="actionsContainer" style="max-height: 0; overflow: hidden; transition: max-height 0.3s ease; margin: 0 20px; position: sticky; top: 65px; z-index: 1150;">
    <div id="actionsInner" style="display: flex; gap: 8px; padding: 15px; background: transparent; border-bottom: 1px solid #ecf0f1; flex-wrap: wrap;">
                <a href="javascript:void(0)" class="btn" id="editBtn"
                   style="padding: 6px 12px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                   onmouseover="this.style.background='#2980b9'"
                   onmouseout="this.style.background='#3498db'">
                    <i class="fas fa-edit" style="margin-left: 5px; font-size: 11px;"></i>
                    تعديل
                </a>

                <button type="button" class="btn" id="viewBtn"
                        style="padding: 6px 12px; background: #17a2b8; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                        onmouseover="this.style.background='#138496'"
                        onmouseout="this.style.background='#17a2b8'">
                    <i class="fas fa-eye" style="margin-left: 5px; font-size: 11px;"></i>
                    عرض
                </button>

                <!-- زر ترحيل/إلغاء ترحيل الفاتورة -->
                <button type="button" class="btn" id="statusBtn" style="display: none;"
                        style="padding: 6px 12px; background: #28a745; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                        onmouseover="this.style.background='#218838'"
                        onmouseout="this.style.background='#28a745'">
                    <i class="fas fa-paper-plane" style="margin-left: 5px; font-size: 11px;"></i>
                    <span id="statusBtnText">ترحيل</span>
                </button>

                <button type="button" class="btn" id="deleteBtn"
                        style="padding: 6px 12px; background: #e74c3c; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                        onmouseover="this.style.background='#c0392b'"
                        onmouseout="this.style.background='#e74c3c'">
                    <i class="fas fa-trash" style="margin-left: 5px; font-size: 11px;"></i>
                    حذف
                </button>

                <a href="javascript:void(0)" class="btn" id="printLocalBtn"
                   style="padding: 6px 12px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                   onmouseover="this.style.background='#27ae60'"
                   onmouseout="this.style.background='#2ecc71'">
                    <i class="fas fa-print" style="margin-left: 5px; font-size: 11px;"></i>
                    طباعة محلية
                </a>

                <button type="button" class="btn" id="printForeignBtn"
                        style="padding: 6px 12px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                        onmouseover="this.style.background='#27ae60'"
                        onmouseout="this.style.background='#2ecc71'">
                    <i class="fas fa-print" style="margin-left: 5px; font-size: 11px;"></i>
                    طباعة أجنبية
                </button>

                <button type="button" class="btn" id="printForeignBtn2"
                        style="padding: 6px 12px; background: #ff9e00; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                        onmouseover="this.style.background='#e68a00'"
                        onmouseout="this.style.background='#ff9e00'">
                    <i class="fas fa-print" style="margin-left: 5px; font-size: 11px;"></i>
                    طباعة لشركة تو ستارز
                </button>

                <button type="button" class="btn" id="printForeignBtn3"
                        style="padding: 6px 12px; background: #3a86ff; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                        onmouseover="this.style.background='#2670e6'"
                        onmouseout="this.style.background='#3a86ff'">
                    <i class="fas fa-file-alt" style="margin-left: 5px; font-size: 11px;"></i>
                    عرض سعر
                </button>

                <button type="button" class="btn" id="printForeignBtn4"
                        style="padding: 6px 12px; background: #ff9e00; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                        onmouseover="this.style.background='#e68a00'"
                        onmouseout="this.style.background='#ff9e00'">
                    <i class="fas fa-boxes" style="margin-left: 5px; font-size: 11px;"></i>
                    فاتورة شحن
                </button>

                <a href="javascript:void(0)" class="btn" id="printPackingBtn"
                   style="padding: 6px 12px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                   onmouseover="this.style.background='#7f8c8d'"
                   onmouseout="this.style.background='#95a5a6'">
                    <i class="fas fa-boxes" style="margin-left: 5px; font-size: 11px;"></i>
                    Packing List
                </a>
            </div>
        </div>

        <!-- جدول الفواتير -->
        <div style="overflow-x: auto;">
            <table class="table" style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr style="background: #f8f9fa;">
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">#</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">رقم الفاتورة</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">العميل</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">التاريخ</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">الأصناف</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: left; font-weight: 600; color: #F19E2C; font-size: 14px;">المبلغ الأجنبي</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: left; font-weight: 600; color: #F19E2C; font-size: 14px;">المبلغ المحلي</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">الحالة</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($invoices)): ?>
                        <tr>
                            <td colspan="8" style="padding: 20px; text-align: center; color: #7f8c8d; font-size: 14px;">
                                <i class="fas fa-file-invoice" style="font-size: 48px; color: #ecf0f1; margin-bottom: 15px; display: block;"></i>
                                لا توجد فواتير
                                <?php if (!empty($search)): ?>
                                    <div style="margin-top: 10px; font-size: 13px;">
                                        لم يتم العثور على نتائج لبحثك: "<?php echo htmlspecialchars($search ?? ''); ?>"
                                    </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($invoices as $index => $invoice): ?>
                        <tr style="border-bottom: 1px solid #ecf0f1; transition: background 0.3s; cursor: pointer;" 
                            onmouseover="this.style.backgroundColor='#f8f9fa'" 
                            onmouseout="this.style.backgroundColor='white'"
                            onclick="selectInvoice(<?php echo $invoice['id']; ?>, this)"
                            data-invoice-id="<?php echo $invoice['id']; ?>"
                            data-invoice-number="<?php echo htmlspecialchars($invoice['invoice_number']); ?>"
                            data-invoice-currency="<?php echo htmlspecialchars($invoice['currency_code']); ?>"
                            data-invoice-status="<?php echo $invoice['status']; ?>"
                            data-invoice-customer="<?php echo htmlspecialchars($invoice['customer_name']); ?>"
                            data-invoice-total="<?php echo $invoice['total_amount']; ?>"
                            data-invoice-total-local="<?php echo $invoice['total_amount_local']; ?>"
                            data-exchange-rates-count="<?php echo $invoice['exchange_rates_count']; ?>"
                            <?php echo ($selectedInvoice && $selectedInvoice['id'] == $invoice['id']) ? 'class="selected"' : ''; ?>>
                            
                            <td style="padding: 12px; text-align: center; color: #7f8c8d; font-size: 14px; vertical-align: middle;">
                                <?php echo $index + 1; ?>
                            </td>
                            
                            <td style="padding: 12px; vertical-align: middle;">
                                <div style="display: flex; align-items: center; justify-content: flex-end;">
                                    <div style="text-align: right;">
                                        <strong style="color: #2c3e50; font-size: 14px;">
                                            <?php echo htmlspecialchars($invoice['invoice_number']); ?>
                                        </strong>
                                        <div style="display: flex; gap: 5px; margin-top: 3px; justify-content: flex-end;">
                                            <span style="background: #e8f4fd; padding: 2px 6px; border-radius: 2px; font-size: 11px; color: #3498db;">
                                                <?php echo htmlspecialchars($invoice['currency_code']); ?>
                                            </span>
                                            <?php if($invoice['exchange_rates_count'] > 0): ?>
                                                <span style="background: #e8f6f3; padding: 2px 6px; border-radius: 2px; font-size: 11px; color: #16a085; display: flex; align-items: center;">
                                                    <i class="fas fa-exchange-alt" style="font-size: 9px; margin-left: 3px;"></i>
                                                    <?php echo $invoice['exchange_rates_count']; ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            
                            <td style="padding: 12px; text-align: right; vertical-align: middle;">
                                <div style="color: #2c3e50; font-weight: 500; font-size: 14px;">
                                    <?php echo htmlspecialchars($invoice['customer_name']); ?>
                                </div>
                                <div style="font-size: 12px; color: #7f8c8d; margin-top: 3px;">
                                    <i class="fas fa-user" style="margin-left: 5px;"></i>
                                    <?php echo htmlspecialchars($invoice['created_by_name']); ?>
                                </div>
                            </td>
                            
                            <td style="padding: 12px; text-align: center; vertical-align: middle;">
                                <div style="color: #34495e; font-size: 14px;">
                                    <?php echo date('Y-m-d', strtotime($invoice['created_at'])); ?>
                                </div>
                                <div style="font-size: 12px; color: #95a5a6;">
                                    <?php echo date('H:i', strtotime($invoice['created_at'])); ?>
                                </div>
                            </td>
                            
                            <td style="padding: 12px; text-align: center; vertical-align: middle;">
                                <span style="background: #e8f4fd; padding: 4px 8px; border-radius: 2px; font-size: 12px; color: #3498db; font-weight: 600;">
                                    <?php echo $invoice['items_count']; ?> صنف
                                </span>
                            </td>
                            
                            <td style="padding: 12px; text-align: left; vertical-align: middle;">
                                <div style="font-weight: 600; color: #27ae60; font-size: 14px;">
                                    <?php echo number_format($invoice['total_amount'], 2); ?> 
                                    <span style="font-size: 12px; color: #7f8c8d;"><?php echo htmlspecialchars($invoice['currency_code']); ?></span>
                                </div>
                            </td>
                            
                            <td style="padding: 12px; text-align: left; vertical-align: middle;">
                                <div style="font-weight: 600; color: #2980b9; font-size: 14px;">
                                    <?php echo number_format($invoice['total_amount_local'], 2); ?>
                                    <span style="font-size: 12px; color: #7f8c8d;">CNY</span>
                                </div>
                            </td>
                            
                            <td style="padding: 12px; text-align: center; vertical-align: middle;">
                                <?php
                                $statusClass = [
                                    'draft' => ['bg' => '#f39c12', 'text' => 'غير مرحله'],
                                    'confirmed' => ['bg' => '#2ecc71', 'text' => 'مرحله'],
                                    'cancelled' => ['bg' => '#e74c3c', 'text' => 'ملغية']
                                ][$invoice['status']] ?? ['bg' => '#95a5a6', 'text' => 'غير معروف'];
                                ?>
                                <span style="background: <?php echo $statusClass['bg']; ?>; color: white; padding: 4px 10px; border-radius: 2px; font-size: 12px; font-weight: 600;">
                                    <?php echo $statusClass['text']; ?>
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- الترويج والتذييل -->
        <div style="padding: 20px; border-top: 1px solid #ecf0f1; background: #f8f9fa;">
            <?php if ($totalInvoices > 0): ?>
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 13px; color: #7f8c8d;">
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    إجمالي الفواتير: <?php echo number_format($totalInvoices); ?> فاتورة
                </div>
                <div style="font-size: 13px; color: #7f8c8d;">
                    <i class="fas fa-calculator" style="margin-left: 5px;"></i>
                    إجمالي القيمة: <?php echo number_format($totalAmount, 2); ?> CNY
                </div>
            </div>
            <?php else: ?>
                <div style="text-align: center; color: #7f8c8d; font-size: 13px;">
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    لا توجد فواتير لعرضها
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- نافذة تأكيد الحذف -->
<div id="deleteModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 10000; align-items: center; justify-content: center;">
    <div style="background: white; width: 90%; max-width: 400px; border-radius: 0; box-shadow: 0 4px 20px rgba(0,0,0,0.2);">
        <div style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f;">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h3 style="margin: 0; font-weight: 600; font-size: 16px;">
                    <i class="fas fa-trash" style="margin-left: 8px;"></i>
                    تأكيد الحذف
                </h3>
                <button onclick="hideDeleteModal()" style="background: none; border: none; color: white; cursor: pointer; font-size: 18px;">×</button>
            </div>
        </div>
        <div style="padding: 20px;">
            <div style="text-align: center; margin-bottom: 20px;">
                <i class="fas fa-exclamation-triangle" style="font-size: 48px; color: #e74c3c; margin-bottom: 15px;"></i>
                <p style="font-size: 16px; color: #2c3e50; margin-bottom: 10px;">هل أنت متأكد من حذف الفاتورة؟</p>
                <p style="font-size: 14px; color: #7f8c8d;" id="deleteMessage">
                    سيتم حذف الفاتورة رقم <strong id="invoiceNumber"></strong> وجميع البيانات المرتبطة بها ولا يمكن التراجع عن هذا الإجراء.
                </p>
            </div>
            <div style="display: flex; gap: 10px; justify-content: flex-end;">
                <button onclick="hideDeleteModal()" style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;">
                    إلغاء
                </button>
                <form method="POST" id="deleteForm" style="margin: 0;">
                    <input type="hidden" name="action" value="delete_invoice">
                    <input type="hidden" name="invoice_id" id="deleteInvoiceId">
                    <button type="submit" style="padding: 8px 20px; background: #e74c3c; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;">
                        نعم، احذف
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- نافذة تأكيد تغيير الحالة -->
<div id="statusModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 10000; align-items: center; justify-content: center;">
    <div style="background: white; width: 90%; max-width: 400px; border-radius: 0; box-shadow: 0 4px 20px rgba(0,0,0,0.2);">
        <div style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f;">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h3 style="margin: 0; font-weight: 600; font-size: 16px;">
                    <i class="fas fa-exchange-alt" style="margin-left: 8px;"></i>
                    تغيير حالة الفاتورة
                </h3>
                <button onclick="hideStatusModal()" style="background: none; border: none; color: white; cursor: pointer; font-size: 18px;">×</button>
            </div>
        </div>
        <div style="padding: 20px;">
            <div style="text-align: center; margin-bottom: 20px;">
                <i class="fas fa-question-circle" style="font-size: 48px; color: #3498db; margin-bottom: 15px;"></i>
                <p style="font-size: 16px; color: #2c3e50; margin-bottom: 10px;" id="statusModalTitle">تأكيد ترحيل الفاتورة</p>
                <p style="font-size: 14px; color: #7f8c8d;" id="statusModalMessage">
                    هل أنت متأكد من ترحيل الفاتورة رقم <strong id="statusInvoiceNumber"></strong>؟
                </p>
            </div>
            <div style="display: flex; gap: 10px; justify-content: flex-end;">
                <button onclick="hideStatusModal()" style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;">
                    إلغاء
                </button>
                <form method="POST" id="statusForm" style="margin: 0;">
                    <input type="hidden" name="action" value="update_invoice_status">
                    <input type="hidden" name="invoice_id" id="statusInvoiceId">
                    <input type="hidden" name="new_status" id="newStatus">
                    <button type="submit" style="padding: 8px 20px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;" id="statusConfirmBtn">
                        نعم، تأكيد
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- نافذة عرض تفاصيل الفاتورة -->
<div id="viewInvoiceModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 10000; align-items: center; justify-content: center;">
    <div style="background: white; width: 90%; max-width: 800px; max-height: 90vh; border-radius: 0; box-shadow: 0 4px 20px rgba(0,0,0,0.2); display: flex; flex-direction: column;">
        <div style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f;">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h3 style="margin: 0; font-weight: 600; font-size: 16px;">
                    <i class="fas fa-file-invoice" style="margin-left: 8px;"></i>
                    تفاصيل الفاتورة
                </h3>
                <button onclick="hideViewInvoiceModal()" style="background: none; border: none; color: white; cursor: pointer; font-size: 18px;">×</button>
            </div>
        </div>
        <div style="padding: 20px; overflow-y: auto; flex: 1;" id="invoiceDetails">
            <!-- سيتم تعبئة البيانات هنا عبر JavaScript -->
        </div>
        <div style="padding: 15px 20px; border-top: 1px solid #ecf0f1; background: #f8f9fa; display: flex; justify-content: flex-end; gap: 10px;">
            <button onclick="hideViewInvoiceModal()" style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;">
                إغلاق
            </button>
            <a href="#" class="btn" id="editInvoiceLink"
               style="padding: 8px 20px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center;">
                <i class="fas fa-edit" style="margin-left: 8px;"></i>
                تعديل الفاتورة
            </a>
        </div>
    </div>
</div>

<!-- نافذة اختيار العملة للطباعة -->
<div id="selectCurrencyModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 10000; align-items: center; justify-content: center;">
    <div style="background: white; width: 90%; max-width: 500px; border-radius: 0; box-shadow: 0 4px 20px rgba(0,0,0,0.2);">
        <div style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f;">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h3 style="margin: 0; font-weight: 600; font-size: 16px;">
                    <i class="fas fa-exchange-alt" style="margin-left: 8px;"></i>
                    اختر العملة للطباعة
                </h3>
                <button onclick="hideSelectCurrencyModal()" style="background: none; border: none; color: white; cursor: pointer; font-size: 18px;">×</button>
            </div>
        </div>
        <div style="padding: 20px;">
            <div style="padding: 12px 15px; background: #e8f4fd; color: #3498db; border: 1px solid #b3e0ff; margin-bottom: 15px; display: flex; align-items: center;">
                <i class="fas fa-info-circle" style="margin-left: 8px;"></i>
                اختر العملة التي تريد طباعة الفاتورة بها. سيتم تحويل جميع المبالغ باستخدام سعر الصرف المسجل وقت إنشاء الفاتورة.
            </div>

            <div id="currencyOptions">
                <!-- سيتم تعبئة خيارات العملات هنا عبر JavaScript -->
            </div>

            <div id="noCurrenciesAlert" style="display: none; padding: 12px 15px; background: #fef9e7; color: #f39c12; border: 1px solid #fdebd0;">
                <i class="fas fa-exclamation-triangle" style="margin-left: 8px;"></i>
                لا توجد أسعار صرف مسجلة لهذه الفاتورة. الرجاء إضافة أسعار الصرف أولاً.
            </div>
        </div>
        <div style="padding: 15px 20px; border-top: 1px solid #ecf0f1; background: #f8f9fa; display: flex; justify-content: flex-end; gap: 10px;">
            <button onclick="hideSelectCurrencyModal()" style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;">
                إلغاء
            </button>
            <button type="button" style="padding: 8px 20px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center;" id="printSelectedCurrency" disabled>
                <i class="fas fa-print" style="margin-left: 8px;"></i>
                طباعة بالعملة المختارة
            </button>
        </div>
    </div>
</div>

<style>
    /* تنسيقات إضافية متناسقة مع واجهة الأصناف */
    .form-control:focus {
        outline: none;
        border-color: #3498db;
        box-shadow: 0 0 0 2px rgba(52,152,219,0.2);
    }
    
    .table tbody tr {
        transition: background-color 0.2s ease;
    }
    
    .table tbody tr.selected {
        background-color: rgba(14, 66, 98, 0.1) !important;
        border-left: 3px solid #F19E2C;
    }
    
    /* تخصيص شريط التمرير */
    ::-webkit-scrollbar {
        width: 8px;
        height: 8px;
    }
    
    ::-webkit-scrollbar-track {
        background: #f1f1f1;
    }
    
    ::-webkit-scrollbar-thumb {
        background: #bdc3c7;
    }
    
    ::-webkit-scrollbar-thumb:hover {
        background: #95a5a6;
    }
    
    /* تنسيق خيارات العملة */
    .currency-option {
        border: 1px solid #dee2e6;
        border-radius: 0;
        padding: 12px;
        margin-bottom: 8px;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .currency-option:hover {
        background-color: #f8f9fa;
        border-color: #3498db;
    }
    
    .currency-option.selected {
        background-color: #e8f4fd;
        border-color: #3498db;
        border-left: 3px solid #F19E2C;
    }
    
    /* إخفاء بعض الأعمدة في الجوال */
    @media (max-width: 768px) {
        .table thead th:nth-child(4), /* التاريخ */
        .table tbody td:nth-child(4),
        .table thead th:nth-child(5), /* الأصناف */
        .table tbody td:nth-child(5),
        .table thead th:nth-child(6), /* المبلغ الأجنبي */
        .table tbody td:nth-child(6),
        .table thead th:nth-child(7), /* المبلغ المحلي */
        .table tbody td:nth-child(7) {
            display: none;
        }
        
        .table thead th,
        .table tbody td {
            padding: 8px 5px !important;
        }
    }
</style>

<script>
// متغيرات عالمية لتخزين الفاتورة المحددة
let selectedInvoiceId = null;
let selectedInvoiceNumber = null;
let selectedInvoiceElement = null;
let selectedCurrencyId = null;
let selectedInvoiceStatus = null;
let currentPrintPage = 'print_invoice_foreign.php';

// اختيار فاتورة
function selectInvoice(invoiceId, element) {
    // إلغاء تحديد الصف السابق إذا كان موجوداً
    if (selectedInvoiceElement) {
        selectedInvoiceElement.classList.remove('selected');
    }

    // تحديد الصف الجديد
    element.classList.add('selected');
    selectedInvoiceElement = element;

    // حفظ بيانات الفاتورة المحددة
    selectedInvoiceId = invoiceId;
    selectedInvoiceNumber = element.getAttribute('data-invoice-number');
    selectedInvoiceStatus = element.getAttribute('data-invoice-status');

    // تحديث روابط الأزرار
    updateActionButtons();

    // إظهار حاوية الأزرار
    showActionsContainer();

    // تمرير سلس إلى الصف المحدد في الجوال
    if (window.innerWidth <= 768) {
        setTimeout(() => {
            const actionsContainer = document.getElementById('actionsContainer');
            actionsContainer.style.maxHeight = actionsContainer.scrollHeight + 'px';
            actionsContainer.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }, 300);
    }
}

// تحديث روابط الأزرار بناءً على الفاتورة المحددة
function updateActionButtons() {
    if (!selectedInvoiceId) return;

    // تحديث روابط الأزرار
    document.getElementById('editBtn').href = `invoice_items.php?invoice_id=${selectedInvoiceId}`;
    document.getElementById('printLocalBtn').onclick =() =>  window.open(`print_invoice.php?invoice_id=${selectedInvoiceId}`, '_blank', 'width=1000,height=700,scrollbars=yes,resizable=yes,toolbar=yes');     
    document.getElementById('printPackingBtn').onclick =() =>  window.open(`quote.php?invoice_id=${selectedInvoiceId}`, '_blank', 'width=1000,height=700,scrollbars=yes,resizable=yes,toolbar=yes');
            

    // تحديث زر تغيير الحالة
    updateStatusButton();

    // إعداد معالج الأحداث للأزرار
    document.getElementById('viewBtn').onclick = () => viewInvoice(selectedInvoiceId);
    document.getElementById('deleteBtn').onclick = () => confirmDelete(selectedInvoiceId, selectedInvoiceNumber);
    document.getElementById('statusBtn').onclick = () => confirmChangeStatus(selectedInvoiceId, selectedInvoiceNumber, selectedInvoiceStatus);

    // زر طباعة العملة الأجنبية (الصفحة الأولى)
    document.getElementById('printForeignBtn').onclick = () => {
        currentPrintPage = 'print_invoice_foreign.php';
        showCurrencySelection(selectedInvoiceId);
    };

    // زر طباعة العملة الأجنبية 2 (الصفحة الثانية)
    document.getElementById('printForeignBtn2').onclick = () => {
        currentPrintPage = 'print_invoice_for_tostart_com.php';
        showCurrencySelection(selectedInvoiceId);
    };
    
    // زر طباعة العملة الأجنبية 3 (الصفحة الثالثة)
    document.getElementById('printForeignBtn4').onclick = () => {
        currentPrintPage = 'print_shipping_invoice.php';
        showCurrencySelection(selectedInvoiceId);
    };

    // زر طباعة العملة الأجنبية 4 (الصفحة الرابعة)
    document.getElementById('printForeignBtn3').onclick = () => {
        currentPrintPage = 'print_qoute.php';
        showCurrencySelection(selectedInvoiceId);
    };
}

// تحديث زر تغيير الحالة
function updateStatusButton() {
    const statusBtn = document.getElementById('statusBtn');
    const statusBtnText = document.getElementById('statusBtnText');
    
    if (!selectedInvoiceStatus) return;

    if (selectedInvoiceStatus === 'draft') {
        statusBtn.style.display = 'inline-flex';
        statusBtn.style.backgroundColor = '#28a745';
        statusBtn.onmouseover = function() { this.style.backgroundColor = '#218838'; };
        statusBtn.onmouseout = function() { this.style.backgroundColor = '#28a745'; };
        statusBtnText.textContent = 'ترحيل';
    } else if (selectedInvoiceStatus === 'confirmed') {
        statusBtn.style.display = 'inline-flex';
        statusBtn.style.backgroundColor = '#6c757d';
        statusBtn.onmouseover = function() { this.style.backgroundColor = '#5a6268'; };
        statusBtn.onmouseout = function() { this.style.backgroundColor = '#6c757d'; };
        statusBtnText.textContent = 'إلغاء الترحيل';
    } else {
        statusBtn.style.display = 'none';
    }
}

// إظهار حاوية أزرار الإجراءات
function showActionsContainer() {
    const container = document.getElementById('actionsContainer');
    container.style.maxHeight = container.scrollHeight + 'px';
}

// إخفاء حاوية أزرار الإجراءات
function hideActionsContainer() {
    const container = document.getElementById('actionsContainer');
    container.style.maxHeight = '0';
}

// تأكيد تغيير حالة الفاتورة
function confirmChangeStatus(invoiceId, invoiceNumber, currentStatus) {
    let newStatus = currentStatus === 'draft' ? 'confirmed' : 'draft';
    let actionText = currentStatus === 'draft' ? 'ترحيل' : 'إلغاء ترحيل';
    let confirmText = currentStatus === 'draft' ? 'ترحيل الفاتورة' : 'إلغاء ترحيل الفاتورة';

    document.getElementById('statusInvoiceId').value = invoiceId;
    document.getElementById('newStatus').value = newStatus;
    document.getElementById('statusInvoiceNumber').textContent = invoiceNumber;
    document.getElementById('statusModalTitle').textContent = 'تأكيد ' + actionText;
    document.getElementById('statusModalMessage').innerHTML =
        `هل أنت متأكد من ${actionText} الفاتورة رقم <strong>${invoiceNumber}</strong>؟`;
    document.getElementById('statusConfirmBtn').textContent = 'نعم، ' + confirmText;

    document.getElementById('statusModal').style.display = 'flex';
}

// تأكيد حذف الفاتورة
function confirmDelete(invoiceId, invoiceNumber) {
    document.getElementById('deleteInvoiceId').value = invoiceId;
    document.getElementById('invoiceNumber').textContent = invoiceNumber;
    document.getElementById('deleteMessage').innerHTML =
        `سيتم حذف الفاتورة رقم <strong>${invoiceNumber}</strong> وجميع البيانات المرتبطة بها ولا يمكن التراجع عن هذا الإجراء.`;

    document.getElementById('deleteModal').style.display = 'flex';
}

// عرض نافذة اختيار العملة
function showCurrencySelection(invoiceId) {
    if (!invoiceId) {
        alert('الرجاء اختيار فاتورة أولاً');
        return;
    }

    // إعادة تعيين المتغيرات
    selectedCurrencyId = null;
    document.getElementById('printSelectedCurrency').disabled = true;

    // جلب أسعار الصرف للفاتورة عبر AJAX
    fetch(`get_invoice_currencies.php?invoice_id=${invoiceId}`)
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            const currencyOptionsDiv = document.getElementById('currencyOptions');
            const noCurrenciesAlert = document.getElementById('noCurrenciesAlert');

            if (data.success && data.currencies && data.currencies.length > 0) {
                noCurrenciesAlert.style.display = 'none';
                currencyOptionsDiv.innerHTML = '';

                // عرض خيارات العملات
                data.currencies.forEach(currency => {
                    const isDefault = currency.is_local == 1;
                    const currencyOption = document.createElement('div');
                    currencyOption.className = 'currency-option';
                    currencyOption.dataset.currencyId = currency.currency_id;
                    currencyOption.innerHTML = `
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <div>
                                <div style="font-weight: 600; color: #2c3e50; margin-bottom: 3px;">
                                    ${currency.currency_name} (${currency.currency_code})
                                    ${isDefault ? '<span style="background: #3498db; color: white; padding: 2px 6px; font-size: 11px; margin-right: 5px;">الافتراضية</span>' : ''}
                                </div>
                                <div style="font-size: 12px; color: #7f8c8d;">
                                    1 ${data.base_currency} = ${parseFloat(currency.exchange_rate).toFixed(6)} ${currency.currency_code}
                                </div>
                            </div>
                            <i class="fas fa-check" style="color: #27ae60; display: none;"></i>
                        </div>
                    `;

                    currencyOption.onclick = function() {
                        selectCurrency(this.dataset.currencyId, this);
                    };
                    currencyOptionsDiv.appendChild(currencyOption);
                });

                // إظهار النافذة
                document.getElementById('selectCurrencyModal').style.display = 'flex';
            } else {
                currencyOptionsDiv.innerHTML = '';
                noCurrenciesAlert.style.display = 'block';
                document.getElementById('selectCurrencyModal').style.display = 'flex';
            }
        })
        .catch(error => {
            alert('حدث خطأ في جلب بيانات العملات: ' + error.message);
        });
}

// اختيار عملة للطباعة
function selectCurrency(currencyId, element) {
    if (!currencyId) {
        return;
    }

    // إلغاء تحديد جميع الخيارات
    document.querySelectorAll('.currency-option').forEach(option => {
        option.classList.remove('selected');
        const checkIcon = option.querySelector('.fa-check');
        if (checkIcon) {
            checkIcon.style.display = 'none';
        }
    });

    // تحديد الخيار المختار
    element.classList.add('selected');
    const checkIcon = element.querySelector('.fa-check');
    if (checkIcon) {
        checkIcon.style.display = 'block';
    }

    // حفظ العملة المختارة
    selectedCurrencyId = currencyId;

    // تفعيل زر الطباعة
    const printBtn = document.getElementById('printSelectedCurrency');
    printBtn.disabled = false;
}

// طباعة الفاتورة بالعملة المختارة
document.getElementById('printSelectedCurrency').onclick = function() {
    if (selectedInvoiceId && selectedCurrencyId) {
        // استخدام الصفحة الحالية المخزنة في المتغير currentPrintPage
        const url = `${currentPrintPage}?invoice_id=${selectedInvoiceId}&currency_id=${selectedCurrencyId}`;
        window.open(url, '_blank', 'width=1000,height=700,scrollbars=yes,resizable=yes,toolbar=yes');
            

        // إغلاق النافذة
        hideSelectCurrencyModal();
    } else {
        alert('الرجاء اختيار عملة أولاً');
    }
};

// عرض تفاصيل الفاتورة
function viewInvoice(invoiceId) {
    // جلب بيانات الفاتورة عبر AJAX
    fetch(`get_invoice_details.php?invoice_id=${invoiceId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const invoice = data.invoice;
                const items = data.items;

                let itemsHtml = '';
                if (items.length > 0) {
                    itemsHtml = items.map(item => `
                        <tr>
                            <td style="padding: 8px; border-bottom: 1px solid #ecf0f1;">${item.item_name}</td>
                            <td style="padding: 8px; border-bottom: 1px solid #ecf0f1; text-align: center;">${item.quantity}</td>
                            <td style="padding: 8px; border-bottom: 1px solid #ecf0f1; text-align: right;">${parseFloat(item.unit_price).toFixed(2)}</td>
                            <td style="padding: 8px; border-bottom: 1px solid #ecf0f1; text-align: right;">${parseFloat(item.total_price).toFixed(2)}</td>
                        </tr>
                    `).join('');
                } else {
                    itemsHtml = '<tr><td colspan="4" style="padding: 20px; text-align: center; color: #7f8c8d;">لا توجد أصناف</td></tr>';
                }

                const statusText = {
                    'draft': 'غير مرحله',
                    'confirmed': 'مرحله',
                    'cancelled': 'ملغاة'
                }[invoice.status] || 'غير مرحله';

                const statusColor = {
                    'draft': '#f39c12',
                    'confirmed': '#2ecc71',
                    'cancelled': '#e74c3c'
                }[invoice.status] || '#95a5a6';

                document.getElementById('invoiceDetails').innerHTML = `
                    <div style="margin-bottom: 20px;">
                        <h4 style="color: #2c3e50; border-bottom: 2px solid #F19E2C; padding-bottom: 8px; margin-bottom: 15px;">
                            <i class="fas fa-file-invoice" style="margin-left: 8px;"></i>
                            معلومات الفاتورة
                        </h4>
                        
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 15px;">
                            <div style="background: #f8f9fa; padding: 15px; border-left: 3px solid #3498db;">
                                <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">رقم الفاتورة</div>
                                <div style="font-size: 16px; font-weight: 600; color: #2c3e50;">${invoice.invoice_number}</div>
                            </div>
                            
                            <div style="background: #f8f9fa; padding: 15px; border-left: 3px solid #2ecc71;">
                                <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">العميل</div>
                                <div style="font-size: 16px; font-weight: 600; color: #2c3e50;">${invoice.customer_name}</div>
                            </div>
                            
                            <div style="background: #f8f9fa; padding: 15px; border-left: 3px solid #9b59b6;">
                                <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">التاريخ</div>
                                <div style="font-size: 16px; font-weight: 600; color: #2c3e50;">
                                    ${new Date(invoice.created_at).toLocaleDateString('ar-EG')}
                                    <span style="font-size: 12px; color: #95a5a6; margin-right: 5px;">${new Date(invoice.created_at).toLocaleTimeString('ar-EG')}</span>
                                </div>
                            </div>
                            
                            <div style="background: #f8f9fa; padding: 15px; border-left: 3px solid ${statusColor};">
                                <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">الحالة</div>
                                <div style="font-size: 16px; font-weight: 600; color: ${statusColor};">${statusText}</div>
                            </div>
                        </div>
                    </div>
                    
                    <div style="margin-bottom: 20px;">
                        <h4 style="color: #2c3e50; border-bottom: 2px solid #F19E2C; padding-bottom: 8px; margin-bottom: 15px;">
                            <i class="fas fa-money-bill-wave" style="margin-left: 8px;"></i>
                            المبالغ
                        </h4>
                        
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px;">
                            <div style="background: #e8f6f3; padding: 15px; border-left: 3px solid #1abc9c;">
                                <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">العملة</div>
                                <div style="font-size: 16px; font-weight: 600; color: #16a085;">
                                    ${invoice.currency_code} (${invoice.currency_name})
                                </div>
                            </div>
                            
                            <div style="background: #fef9e7; padding: 15px; border-left: 3px solid #f1c40f;">
                                <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">سعر الصرف</div>
                                <div style="font-size: 16px; font-weight: 600; color: #f39c12;">
                                    ${parseFloat(invoice.exchange_rate).toFixed(6)}
                                </div>
                            </div>
                            
                            <div style="background: #e8f4fd; padding: 15px; border-left: 3px solid #3498db;">
                                <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">الإجمالي الأجنبي</div>
                                <div style="font-size: 16px; font-weight: 600; color: #2980b9;">
                                    ${parseFloat(invoice.total_amount).toFixed(2)} ${invoice.currency_code}
                                </div>
                            </div>
                            
                            <div style="background: #fdedec; padding: 15px; border-left: 3px solid #e74c3c;">
                                <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">الإجمالي المحلي</div>
                                <div style="font-size: 16px; font-weight: 600; color: #c0392b;">
                                    ${parseFloat(invoice.total_amount_local).toFixed(2)} CNY
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        <h4 style="color: #2c3e50; border-bottom: 2px solid #F19E2C; padding-bottom: 8px; margin-bottom: 15px;">
                            <i class="fas fa-cubes" style="margin-left: 8px;"></i>
                            أصناف الفاتورة (${items.length} صنف)
                        </h4>
                        
                        <div style="overflow-x: auto;">
                            <table style="width: 100%; border-collapse: collapse;">
                                <thead>
                                    <tr style="background: #f8f9fa;">
                                        <th style="padding: 10px; border-bottom: 2px solid #ecf0f1; text-align: right; font-weight: 600; color: #2c3e50;">الصنف</th>
                                        <th style="padding: 10px; border-bottom: 2px solid #ecf0f1; text-align: center; font-weight: 600; color: #2c3e50;">الكمية</th>
                                        <th style="padding: 10px; border-bottom: 2px solid #ecf0f1; text-align: right; font-weight: 600; color: #2c3e50;">سعر الوحدة</th>
                                        <th style="padding: 10px; border-bottom: 2px solid #ecf0f1; text-align: right; font-weight: 600; color: #2c3e50;">الإجمالي</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    ${itemsHtml}
                                </tbody>
                                <tfoot>
                                    <tr style="background: #2c3e50; color: white;">
                                        <td colspan="3" style="padding: 12px; text-align: left; font-weight: 600;">
                                            <i class="fas fa-calculator" style="margin-left: 8px;"></i>
                                            المجموع:
                                        </td>
                                        <td style="padding: 12px; text-align: right; font-weight: 600;">
                                            ${parseFloat(invoice.total_amount).toFixed(2)} ${invoice.currency_code}
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                `;

                document.getElementById('editInvoiceLink').href = `invoice_items.php?invoice_id=${invoiceId}`;
                document.getElementById('viewInvoiceModal').style.display = 'flex';
            } else {
                alert('خطأ في جلب بيانات الفاتورة: ' + data.message);
            }
        })
        .catch(error => {
            alert('حدث خطأ في الشبكة: ' + error);
        });
}

// وظائف إخفاء النوافذ المنبثقة
function hideDeleteModal() {
    document.getElementById('deleteModal').style.display = 'none';
}

function hideStatusModal() {
    document.getElementById('statusModal').style.display = 'none';
}

function hideViewInvoiceModal() {
    document.getElementById('viewInvoiceModal').style.display = 'none';
}

function hideSelectCurrencyModal() {
    document.getElementById('selectCurrencyModal').style.display = 'none';
}

// إغلاق النوافذ المنبثقة عند النقر خارجها
window.onclick = function(event) {
    const modals = ['deleteModal', 'statusModal', 'viewInvoiceModal', 'selectCurrencyModal'];
    modals.forEach(modalId => {
        const modal = document.getElementById(modalId);
        if (event.target == modal) {
            modal.style.display = 'none';
        }
    });
};

// إضافة تأثيرات تفاعلية عند تحميل الصفحة
document.addEventListener('DOMContentLoaded', function() {
    // إذا كان هناك فاتورة محددة عند تحميل الصفحة، اخترها
    <?php if ($selectedInvoice): ?>
        const selectedRow = document.querySelector(`tr[data-invoice-id="<?= $selectedInvoice['id'] ?>"]`);
        if (selectedRow) {
            setTimeout(() => {
                selectInvoice(<?= $selectedInvoice['id'] ?>, selectedRow);
            }, 100);
        }
    <?php endif; ?>

    // إخفاء حاوية الأزرار عند النقر خارج الجدول
    document.addEventListener('click', function(event) {
        const table = document.querySelector('.table');
        const actionsContainer = document.getElementById('actionsContainer');

        // التحقق إذا كان النقر على أي من أزرار الإجراءات أو داخل النافذة المنبثقة
        const isModal = event.target.closest('#deleteModal') || 
                        event.target.closest('#statusModal') ||
                        event.target.closest('#viewInvoiceModal') ||
                        event.target.closest('#selectCurrencyModal');
        
        const isActionButton = event.target.closest('#actionsContainer') || 
                              event.target.closest('.btn') ||
                              isModal;

        // إذا تم النقر خارج الجدول وخارج حاوية الأزرار وخارج النوافذ المنبثقة
        if (!table.contains(event.target) && !isActionButton) {
            if (selectedInvoiceElement) {
                selectedInvoiceElement.classList.remove('selected');
                selectedInvoiceElement = null;
                selectedInvoiceId = null;
                selectedInvoiceNumber = null;
                selectedInvoiceStatus = null;
                hideActionsContainer();
            }
        }
    });

    // إضافة وظيفة البحث السريع
    const searchInput = document.querySelector('input[name="search"]');
    if (searchInput) {
        searchInput.addEventListener('input', function() {
            const searchTerm = this.value.toLowerCase();
            const rows = document.querySelectorAll('.table tbody tr');
            
            rows.forEach(row => {
                const invoiceNumber = row.getAttribute('data-invoice-number') || '';
                const customerName = row.getAttribute('data-invoice-customer') || '';
                
                if (invoiceNumber.toLowerCase().includes(searchTerm) || 
                    customerName.toLowerCase().includes(searchTerm)) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        });
    }
});
</script>

<?php
include 'views/layout/footer.php';
?>