<?php
session_start();
require_once 'config.php';
require_once 'InvoiceManager.php';

header('Content-Type: application/json');

$itemId = $_GET['item_id'] ?? 0;

if (!$itemId) {
    echo json_encode(['success' => false, 'message' => 'معرف الصنف مطلوب']);
    exit;
}

try {
    $invoiceManager = new InvoiceManager();
    
    // استخدام دالة getInvoiceItem التي أنشأناها
    $item = $invoiceManager->getInvoiceItem($itemId);
    
    if ($item) {
        echo json_encode([
            'success' => true,
            'item' => [
                'id' => $item['id'],
                'item_id' => $item['item_id'],
                'quantity' => $item['quantity'],
                'unit_price' => $item['unit_price'],
                'company_id' => $item['company_id']
            ]
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'لم يتم العثور على الصنف']);
    }
} catch(Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>