<?php
// core/Auth.php
require_once $_SERVER['DOCUMENT_ROOT'] . '/gts/core/Database.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/gts/core/Session.php';

class Auth {
    private $db;
    private $session;
    
    public function __construct() {
        $this->db = Database::getInstance();
        $this->session = new Session();
    }
    
    public function login($username, $password) {
        try {
            $sql = "SELECT u.*, r.name as role_name, r.permissions 
                    FROM users u 
                    JOIN roles r ON u.role_id = r.id 
                    WHERE u.username = ? AND u.is_active = 1";
            $stmt = $this->db->query($sql, [$username]);
            $user = $stmt->fetch();
            
            if ($user && password_verify($password, $user['password'])) {
                // إزالة كلمة المرور من بيانات الجلسة
                unset($user['password']);
                $user['permissions'] = json_decode($user['permissions'], true);
                
                $this->session->setUser($user);
                
                // تسجيل نشاط الدخول
                $this->logActivity($user['id'], 'login', 'user', $user['id'], null, [
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'user_agent' => $_SERVER['HTTP_USER_AGENT']
                ]);
                
                return true;
            }
            
            return false;
        } catch (Exception $e) {
            error_log("خطأ في تسجيل الدخول: " . $e->getMessage());
            return false;
        }
    }
    
    public function logout() {
        $user = $this->session->getUser();
        if ($user) {
            $this->logActivity($user['id'], 'logout', 'user', $user['id']);
        }
        $this->session->destroy();
    }
    
    public function checkPermission($entity, $action) {
        $user = $this->session->getUser();
        if (!$user) return false;
        
        if ($user['role_name'] === 'Admin') {
            return true;
        }
        
        $permissions = $user['permissions'] ?? [];
        return isset($permissions[$entity]) && in_array($action, $permissions[$entity]);
    }
    
    public function getUser() {
        return $this->session->getUser();
    }
    
    public function isLoggedIn() {
        return $this->session->isLoggedIn();
    }
    
    private function logActivity($userId, $action, $entityType, $entityId, $oldValues = null, $additionalData = []) {
        try {
            $sql = "INSERT INTO activity_logs 
                    (user_id, action, entity_type, entity_id, old_values, new_values, ip_address, user_agent) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            
            $this->db->query($sql, [
                $userId,
                $action,
                $entityType,
                $entityId,
                $oldValues ? json_encode($oldValues, JSON_UNESCAPED_UNICODE) : null,
                $additionalData ? json_encode($additionalData, JSON_UNESCAPED_UNICODE) : null,
                $_SERVER['REMOTE_ADDR'] ?? 'unknown',
                $_SERVER['HTTP_USER_AGENT'] ?? 'unknown'
            ]);
        } catch (Exception $e) {
            error_log("خطأ في تسجيل النشاط: " . $e->getMessage());
        }
    }
}
?>