<?php
// controllers/AuthController.php
require_once 'core/Auth.php';
require_once 'core/Session.php';

class AuthController {
    private $auth;
    private $session;
    
    public function __construct() {
        $this->auth = new Auth();
        $this->session = new Session();
    }
    
    public function login() {
        // إذا كان المستخدم مسجل الدخول بالفعل، توجيه للصفحة الرئيسية
        if ($this->auth->isLoggedIn()) {
            header('Location: index.php');
            exit;
        }
        
        $error = '';
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $username = $_POST['username'] ?? '';
            $password = $_POST['password'] ?? '';
            
            if (empty($username) || empty($password)) {
                $error = 'يرجى إدخال اسم المستخدم وكلمة المرور';
            } elseif ($this->auth->login($username, $password)) {
                header('Location: index.php');
                exit;
            } else {
                $error = 'اسم المستخدم أو كلمة المرور غير صحيحة';
            }
        }
        
        // تمرير المتغيرات للفيو
        $auth = $this->auth;
        $session = $this->session;
        include 'views/auth/login.php';
    }
    
    public function logout() {
        $this->auth->logout();
        header('Location: login.php');
        exit;
    }
}
?>