<?php
session_start();
require_once 'reports_vouchers/db.php';

// جلب جميع الشركات
try {
    $stmt = $pdo->query("SELECT * FROM companies ORDER BY created_at DESC");
    $companies = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $error = "خطأ في تحميل بيانات الشركات: " . $e->getMessage();
    $companies = [];
}

// حساب الإحصائيات
$totalCompanies = count($companies);
$activeCount = 0;
$inactiveCount = 0;
$totalOpeningBalance = 0;
$totalCurrentBalance = 0;

foreach($companies as $company) {
    if($company['is_active']) $activeCount++;
    else $inactiveCount++;
    $totalOpeningBalance += abs($company['opening_balance']);
    $totalCurrentBalance += abs($company['current_balance']);
}
?>

<?php include 'views/layout/header.php'; ?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0;padding: 8px; margin: 5px auto; max-width: 1200px;">
    <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0; position: sticky; top: 0; z-index: 1100;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-building" style="margin-left: 8px;"></i>
                إدارة الشركات
            </h2>
            <button type="button" onclick="addCompany()" class="btn" 
                   style="padding: 8px 16px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                   onmouseover="this.style.background='#27ae60'"
                   onmouseout="this.style.background='#2ecc71'">
                <i class="fas fa-plus" style="margin-left: 8px;"></i>
                إضافة شركة جديدة
            </button>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <!-- شريط البحث والإحصائيات -->
        <div style="padding: 20px; border-bottom: 1px solid #ecf0f1;">
            <!-- شريط البحث -->
            <div style="margin-bottom: 15px;">
                <div style="position: relative; max-width: 500px;">
                    <input type="text" id="searchInput" class="form-control" 
                           placeholder="ابحث عن شركة..." 
                           style="width: 100%; padding: 10px 12px 10px 40px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;">
                    <i class="fas fa-search" style="position: absolute; left: 12px; top: 50%; transform: translateY(-50%); color: #7f8c8d;"></i>
                </div>
            </div>

            <!-- مرشحات الحالة -->
            <div style="margin-bottom: 15px; display: flex; gap: 8px;">
                <button type="button" class="btn filter-btn active" data-status="all"
                        style="padding: 6px 12px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer;">
                    الكل
                </button>
                <button type="button" class="btn filter-btn" data-status="active"
                        style="padding: 6px 12px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer;">
                    نشط
                </button>
                <button type="button" class="btn filter-btn" data-status="inactive"
                        style="padding: 6px 12px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 12px; cursor: pointer;">
                    غير نشط
                </button>
            </div>

            <!-- الإحصائيات -->
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 10px;">
                <div style="background: #e8f6f3; padding: 15px; border-left: 4px solid #1abc9c;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">إجمالي الشركات</div>
                    <div style="font-size: 24px; font-weight: bold; color: #16a085;"><?php echo number_format($totalCompanies); ?></div>
                </div>
                <div style="background: #fef9e7; padding: 15px; border-left: 4px solid #f1c40f;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">شركات نشطة</div>
                    <div style="font-size: 24px; font-weight: bold; color: #f39c12;"><?php echo number_format($activeCount); ?></div>
                </div>
                <div style="background: #fdedec; padding: 15px; border-left: 4px solid #e74c3c;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">شركات غير نشطة</div>
                    <div style="font-size: 24px; font-weight: bold; color: #c0392b;"><?php echo number_format($inactiveCount); ?></div>
                </div>
                <div style="background: #e8f4fd; padding: 15px; border-left: 4px solid #3498db;">
                    <div style="font-size: 12px; color: #7f8c8d; margin-bottom: 5px;">إجمالي الأرصدة الحالية</div>
                    <div style="font-size: 24px; font-weight: bold; color: #2980b9;">
                        <?php echo number_format($totalCurrentBalance, 2); ?> 
                        <span style="font-size: 14px;">ر.س</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- رسائل النجاح والخطأ -->
        <?php if (isset($_SESSION['message'])): ?>
            <div style="margin: 10px 12px; padding: 8px 12px; background: #d4edda; color: #155724; border: 1px solid #c3e6cb; border-radius: 0; display: flex; align-items: center; justify-content: space-between;">
                <div style="display: flex; align-items: center;">
                    <i class="fas fa-check-circle" style="margin-left: 8px; color: #28a745;"></i>
                    <?php echo htmlspecialchars($_SESSION['message']); unset($_SESSION['message']); ?>
                </div>
                <button onclick="this.parentElement.style.display='none'" style="background: none; border: none; color: #155724; cursor: pointer;">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
            <div style="margin: 15px 20px; padding: 12px 15px; background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; border-radius: 0; display: flex; align-items: center; justify-content: space-between;">
                <div style="display: flex; align-items: center;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 8px; color: #dc3545;"></i>
                    <?php echo htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?>
                </div>
                <button onclick="this.parentElement.style.display='none'" style="background: none; border: none; color: #721c24; cursor: pointer;">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        <?php endif; ?>

        <?php if (isset($error)): ?>
            <div style="margin: 15px 20px; padding: 12px 15px; background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; border-radius: 0; display: flex; align-items: center; justify-content: space-between;">
                <div style="display: flex; align-items: center;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 8px; color: #dc3545;"></i>
                    <?php echo htmlspecialchars($error); ?>
                </div>
                <button onclick="this.parentElement.style.display='none'" style="background: none; border: none; color: #721c24; cursor: pointer;">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        <?php endif; ?>

        <!-- جدول الشركات -->
        <div style="overflow-x: auto;">
            <table class="table" style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr style="background: #f8f9fa;">
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">#</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">اسم الشركة</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">الهاتف</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: right; font-weight: 600; color: #F19E2C; font-size: 14px;">العنوان</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: left; font-weight: 600; color: #F19E2C; font-size: 14px;">الرصيد الافتتاحي</th>
                  
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">الحالة</th>
                        <th style="padding: 12px; border-bottom: 1px solid #000; text-align: center; font-weight: 600; color: #F19E2C; font-size: 14px;">الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($companies)): ?>
                        <tr>
                            <td colspan="8" style="padding: 20px; text-align: center; color: #7f8c8d; font-size: 14px;">
                                <i class="fas fa-building" style="font-size: 48px; color: #ecf0f1; margin-bottom: 15px; display: block;"></i>
                                لا توجد شركات
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($companies as $index => $company): ?>
                        <tr style="border-bottom: 1px solid #ecf0f1; transition: background 0.3s;" 
                            onmouseover="this.style.backgroundColor='#f8f9fa'" 
                            onmouseout="this.style.backgroundColor='white'"
                            data-status="<?php echo $company['is_active'] ? 'active' : 'inactive'; ?>"
                            data-search="<?php echo htmlspecialchars(strtolower($company['name'] . ' ' . $company['phone'] . ' ' . $company['address'])); ?>">
                            
                            <td style="padding: 12px; text-align: center; color: #7f8c8d; font-size: 14px; vertical-align: middle;">
                                <?php echo $index + 1; ?>
                            </td>
                            
                            <td style="padding: 12px; vertical-align: middle;">
                                <div style="display: flex; align-items: center; justify-content: flex-end;">
                                    <div style="text-align: right;">
                                        <strong style="color: #2c3e50; font-size: 14px;">
                                            <?php echo htmlspecialchars($company['name']); ?>
                                        </strong>
                                    </div>
                                </div>
                            </td>
                            
                            <td style="padding: 12px; text-align: right; vertical-align: middle;">
                                <div style="color: #34495e; font-size: 14px;">
                                    <?php echo htmlspecialchars($company['phone']); ?>
                                </div>
                            </td>
                            
                            <td style="padding: 12px; text-align: right; vertical-align: middle;">
                                <div style="color: #7f8c8d; font-size: 13px; max-width: 200px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">
                                    <?php echo htmlspecialchars($company['address']); ?>
                                </div>
                            </td>
                            
                            <td style="padding: 12px; text-align: left; vertical-align: middle;">
                                <div style="font-weight: 600; <?php echo $company['opening_balance'] >= 0 ? 'color: #27ae60;' : 'color: #e74c3c;'; ?> font-size: 14px;">
                                    <?php echo number_format(abs($company['opening_balance']), 2); ?> 
                                    <span style="font-size: 12px; color: #7f8c8d;">
                                        (<?php echo $company['opening_balance'] >= 0 ? 'مدين' : 'دائن'; ?>)
                                    </span>
                                </div>
                            </td>
                            
                           
                            
                            <td style="padding: 12px; text-align: center; vertical-align: middle;min-width: 100px;">
                                <?php if ($company['is_active']): ?>
                                <span style="background: #2ecc71; color: white; padding: 4px 10px; border-radius: 2px; font-size: 12px; font-weight: 600;">
                                    نشط
                                </span>
                                <?php else: ?>
                                <span style="background: #e74c3c; color: white; padding: 4px 10px; border-radius: 2px; font-size: 12px; font-weight: 600;">
                                    غير نشط
                                </span>
                                <?php endif; ?>
                            </td>
                            
                            <td style="padding: 12px; text-align: center; vertical-align: middle;">
                                <div style="display: flex; gap: 5px; justify-content: center;">
                                    <button type="button" onclick="editCompany(<?php echo $company['id']; ?>)" 
                                            class="btn" 
                                            style="padding: 4px 8px; background: #3498db; color: white; border: none; border-radius: 0; font-size: 11px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                                            onmouseover="this.style.background='#2980b9'"
                                            onmouseout="this.style.background='#3498db'">
                                        <i class="fas fa-edit" style="margin-left: 4px; font-size: 10px;"></i>
                                        تعديل
                                    </button>
                                    
                                    <button type="button" onclick="deleteCompany(<?php echo $company['id']; ?>, '<?php echo htmlspecialchars(addslashes($company['name'])); ?>')" 
                                            class="btn" 
                                            style="padding: 4px 8px; background: #e74c3c; color: white; border: none; border-radius: 0; font-size: 11px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                                            onmouseover="this.style.background='#c0392b'"
                                            onmouseout="this.style.background='#e74c3c'">
                                        <i class="fas fa-trash" style="margin-left: 4px; font-size: 10px;"></i>
                                        حذف
                                    </button>
                                    
                                 
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- الترويج والتذييل -->
        <div style="padding: 20px; border-top: 1px solid #ecf0f1; background: #f8f9fa;">
            <?php if ($totalCompanies > 0): ?>
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 13px; color: #7f8c8d;">
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    إجمالي الشركات: <?php echo number_format($totalCompanies); ?> شركة
                </div>
                <div style="font-size: 13px; color: #7f8c8d;">
                    <i class="fas fa-calculator" style="margin-left: 5px;"></i>
                    إجمالي الأرصدة: <?php echo number_format($totalCurrentBalance, 2); ?> ر.س
                </div>
            </div>
            <?php else: ?>
                <div style="text-align: center; color: #7f8c8d; font-size: 13px;">
                    <i class="fas fa-info-circle" style="margin-left: 5px;"></i>
                    لا توجد شركات لعرضها
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal for Add/Edit Company -->
<div id="companyModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 10000; align-items: center; justify-content: center;">
    <div style="background: white; width: 90%; max-width: 600px; border-radius: 0; box-shadow: 0 4px 20px rgba(0,0,0,0.2);">
        <div style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f;">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h3 style="margin: 0; font-weight: 600; font-size: 16px;">
                    <i class="fas fa-building" style="margin-left: 8px;"></i>
                    <span id="modalTitle">إضافة شركة جديدة</span>
                </h3>
                <button onclick="hideCompanyModal()" style="background: none; border: none; color: white; cursor: pointer; font-size: 18px;">×</button>
            </div>
        </div>
        
        <form id="companyForm" method="POST" action="ajax_companies.php" style="margin: 0;">
            <input type="hidden" id="companyId" name="companyId">
            <input type="hidden" name="action" id="formAction" value="save_company">
            
            <div style="padding: 20px;">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 15px;">
                    <div>
                        <label for="name" style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50;">اسم الشركة *</label>
                        <input type="text" class="form-control" id="name" name="name" required
                               style="width: 100%; padding: 8px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;">
                    </div>
                    
                    <div>
                        <label for="phone" style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50;">رقم الهاتف</label>
                        <input type="text" class="form-control" id="phone" name="phone"
                               style="width: 100%; padding: 8px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;">
                    </div>
                </div>
                
                <div style="margin-bottom: 15px;">
                    <label for="address" style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50;">العنوان</label>
                    <textarea class="form-control" id="address" name="address" rows="2"
                              style="width: 100%; padding: 8px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; direction: ltr;"></textarea>
                </div>
                
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 15px;">
                    <div>
                        <label for="opening_balance" style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50;">الرصيد الافتتاحي</label>
                        <div style="display: flex;">
                            <input type="number" class="form-control" id="opening_balance" name="opening_balance" step="0.01" value="0.00"
                                   style="flex: 1; padding: 8px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;">
                            <select class="form-control" id="balance_type" name="balance_type" 
                                    style="width: 100px; padding: 8px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; margin-right: -1px;">
                                <option value="debit">مدين</option>
                                <option value="credit">دائن</option>
                            </select>
                        </div>
                    </div>
                    
                    <div>
                        <label for="is_active" style="display: block; margin-bottom: 5px; font-weight: 600; color: #2c3e50;">حالة الشركة</label>
                        <select class="form-control" id="is_active" name="is_active"
                                style="width: 100%; padding: 8px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;">
                            <option value="1">نشط</option>
                            <option value="0">غير نشط</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <div style="padding: 15px 20px; border-top: 1px solid #ecf0f1; background: #f8f9fa; display: flex; justify-content: flex-end; gap: 10px;">
                <button type="button" onclick="hideCompanyModal()" 
                        style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;">
                    إلغاء
                </button>
                <button type="submit" 
                        style="padding: 8px 20px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;">
                    حفظ البيانات
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Modal for Transactions -->
<div id="transactionsModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 10000; align-items: center; justify-content: center;">
    <div style="background: white; width: 90%; max-width: 900px; max-height: 80vh; border-radius: 0; box-shadow: 0 4px 20px rgba(0,0,0,0.2); display: flex; flex-direction: column;">
        <div style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f;">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h3 style="margin: 0; font-weight: 600; font-size: 16px;">
                    <i class="fas fa-history" style="margin-left: 8px;"></i>
                    حركات الشركة
                </h3>
                <button onclick="hideTransactionsModal()" style="background: none; border: none; color: white; cursor: pointer; font-size: 18px;">×</button>
            </div>
        </div>
        
        <div style="padding: 20px; overflow-y: auto; flex: 1;">
            <div id="transactionsContent">
                <!-- سيتم تعبئة البيانات هنا عبر JavaScript -->
            </div>
        </div>
        
        <div style="padding: 15px 20px; border-top: 1px solid #ecf0f1; background: #f8f9fa; display: flex; justify-content: flex-end;">
            <button onclick="hideTransactionsModal()" 
                    style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer;">
                إغلاق
            </button>
        </div>
    </div>
</div>

<style>
    /* تنسيقات إضافية متناسقة مع واجهة الفواتير */
    .form-control:focus {
        outline: none;
        border-color: #3498db;
        box-shadow: 0 0 0 2px rgba(52,152,219,0.2);
    }
    
    .table tbody tr {
        transition: background-color 0.2s ease;
    }
    
    /* تخصيص شريط التمرير */
    ::-webkit-scrollbar {
        width: 8px;
        height: 8px;
    }
    
    ::-webkit-scrollbar-track {
        background: #f1f1f1;
    }
    
    ::-webkit-scrollbar-thumb {
        background: #bdc3c7;
    }
    
    ::-webkit-scrollbar-thumb:hover {
        background: #95a5a6;
    }
    
    /* إخفاء بعض الأعمدة في الجوال */
    @media (max-width: 768px) {
        .table thead th:nth-child(3), /* الهاتف */
        .table tbody td:nth-child(3),
        .table thead th:nth-child(4), /* العنوان */
        .table tbody td:nth-child(4),
        .table thead th:nth-child(5), /* الرصيد الافتتاحي */
        .table tbody td:nth-child(5) {
            display: none;
        }
        
        .table thead th,
        .table tbody td {
            padding: 8px 5px !important;
        }
        
        .btn {
            padding: 3px 6px !important;
            font-size: 10px !important;
        }
        
        .btn i {
            font-size: 9px !important;
            margin-left: 3px !important;
        }
    }
</style>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// وظائف إظهار وإخفاء النوافذ المنبثقة
function showCompanyModal() {
    document.getElementById('companyModal').style.display = 'flex';
}

function hideCompanyModal() {
    document.getElementById('companyModal').style.display = 'none';
}

function showTransactionsModal() {
    document.getElementById('transactionsModal').style.display = 'flex';
}

function hideTransactionsModal() {
    document.getElementById('transactionsModal').style.display = 'none';
}

// إغلاق النوافذ المنبثقة عند النقر خارجها
window.onclick = function(event) {
    const modals = ['companyModal', 'transactionsModal'];
    modals.forEach(modalId => {
        const modal = document.getElementById(modalId);
        if (event.target == modal) {
            if (modalId === 'companyModal') hideCompanyModal();
            if (modalId === 'transactionsModal') hideTransactionsModal();
        }
    });
};

// إضافة شركة جديدة
function addCompany() {
    document.getElementById('modalTitle').textContent = 'إضافة شركة جديدة';
    document.getElementById('companyId').value = '';
    document.getElementById('formAction').value = 'save_company';
    document.getElementById('companyForm').reset();
    document.getElementById('balance_type').value = 'debit';
    document.getElementById('is_active').value = '1';
    showCompanyModal();
}

// تعديل شركة
function editCompany(id) {
    fetch('ajax_companies.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'action=get_company&id=' + id
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const company = data.data;
            document.getElementById('modalTitle').textContent = 'تعديل بيانات الشركة';
            document.getElementById('companyId').value = company.id;
            document.getElementById('name').value = company.name;
            document.getElementById('phone').value = company.phone;
            document.getElementById('address').value = company.address;
            
            // ضبط الرصيد الافتتاحي والنوع
            if (company.opening_balance >= 0) {
                document.getElementById('opening_balance').value = Math.abs(company.opening_balance);
                document.getElementById('balance_type').value = 'debit';
            } else {
                document.getElementById('opening_balance').value = Math.abs(company.opening_balance);
                document.getElementById('balance_type').value = 'credit';
            }
            
            document.getElementById('is_active').value = company.is_active;
            document.getElementById('formAction').value = 'save_company';
            showCompanyModal();
        } else {
            Swal.fire('خطأ', data.message, 'error');
        }
    })
    .catch(error => {
        Swal.fire('خطأ', 'حدث خطأ أثناء تحميل البيانات', 'error');
    });
}

// حذف شركة
function deleteCompany(id, name) {
    Swal.fire({
        title: 'تأكيد الحذف',
        html: `هل أنت متأكد من حذف الشركة <strong>${name}</strong> وجميع العمليات المرتبطة بها؟`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'نعم، احذف',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            const formData = new FormData();
            formData.append('action', 'delete_company');
            formData.append('id', id);
            
            fetch('ajax_companies.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'تم الحذف',
                        text: data.message,
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire('خطأ', data.message, 'error');
                }
            })
            .catch(error => {
                Swal.fire('خطأ', 'حدث خطأ أثناء الحذف', 'error');
            });
        }
    });
}

// عرض حركات الشركة
function viewTransactions(id, type) {
    fetch('ajax_transactions.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `action=get_transactions&account_type=${type}&account_id=${id}`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            let html = '';
            
            if (data.data && data.data.length > 0) {
                html = `
                <div style="overflow-x: auto;">
                    <table style="width: 100%; border-collapse: collapse;">
                        <thead>
                            <tr style="background: #f8f9fa;">
                                <th style="padding: 10px; border-bottom: 2px solid #ecf0f1; text-align: right; font-weight: 600; color: #2c3e50;">التاريخ</th>
                                <th style="padding: 10px; border-bottom: 2px solid #ecf0f1; text-align: right; font-weight: 600; color: #2c3e50;">نوع السند</th>
                                <th style="padding: 10px; border-bottom: 2px solid #ecf0f1; text-align: right; font-weight: 600; color: #2c3e50;">الوصف</th>
                                <th style="padding: 10px; border-bottom: 2px solid #ecf0f1; text-align: left; font-weight: 600; color: #2c3e50;">مدين</th>
                                <th style="padding: 10px; border-bottom: 2px solid #ecf0f1; text-align: left; font-weight: 600; color: #2c3e50;">دائن</th>
                                <th style="padding: 10px; border-bottom: 2px solid #ecf0f1; text-align: left; font-weight: 600; color: #2c3e50;">الرصيد بعد العملية</th>
                            </tr>
                        </thead>
                        <tbody>`;
                
                data.data.forEach(transaction => {
                    const debitAmount = parseFloat(transaction.debit_amount) || 0;
                    const creditAmount = parseFloat(transaction.credit_amount) || 0;
                    const balanceAfter = parseFloat(transaction.balance_after) || 0;
                    
                    html += `
                    <tr style="border-bottom: 1px solid #ecf0f1;">
                        <td style="padding: 10px; text-align: right; color: #34495e;">${transaction.date || '-'}</td>
                        <td style="padding: 10px; text-align: right; color: #34495e;">
                            ${transaction.voucher_type === 'receipt' ? 'سند قبض' : 
                              transaction.voucher_type === 'payment' ? 'سند صرف' : 
                              transaction.voucher_type === 'opening' ? 'رصيد افتتاحي' : '-'}
                        </td>
                        <td style="padding: 10px; text-align: right; color: #7f8c8d;">${transaction.description || '-'}</td>
                        <td style="padding: 10px; text-align: left; color: #27ae60; font-weight: 600;">
                            ${debitAmount > 0 ? debitAmount.toFixed(2) : '0.00'}
                        </td>
                        <td style="padding: 10px; text-align: left; color: #e74c3c; font-weight: 600;">
                            ${creditAmount > 0 ? creditAmount.toFixed(2) : '0.00'}
                        </td>
                        <td style="padding: 10px; text-align: left; ${balanceAfter >= 0 ? 'color: #27ae60;' : 'color: #e74c3c;'} font-weight: 600;">
                            ${Math.abs(balanceAfter).toFixed(2)}
                            <span style="font-size: 12px; color: #95a5a6; margin-right: 5px;">
                                (${balanceAfter >= 0 ? 'مدين' : 'دائن'})
                            </span>
                        </td>
                    </tr>`;
                });
                
                html += `
                        </tbody>
                    </table>
                </div>`;
            } else {
                html = `
                <div style="text-align: center; padding: 40px 20px; color: #7f8c8d;">
                    <i class="fas fa-history" style="font-size: 48px; color: #ecf0f1; margin-bottom: 15px; display: block;"></i>
                    لا توجد حركات لهذه الشركة
                </div>`;
            }
            
            document.getElementById('transactionsContent').innerHTML = html;
            showTransactionsModal();
        } else {
            Swal.fire('معلومات', 'لا توجد حركات لهذه الشركة', 'info');
        }
    })
    .catch(error => {
        Swal.fire('خطأ', 'حدث خطأ أثناء تحميل الحركات', 'error');
    });
}

// البحث في الجدول
document.getElementById('searchInput').addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    const rows = document.querySelectorAll('.table tbody tr');
    
    rows.forEach(row => {
        const searchData = row.getAttribute('data-search') || '';
        if (searchData.includes(searchTerm)) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
});

// التصفية حسب الحالة
document.querySelectorAll('.filter-btn').forEach(btn => {
    btn.addEventListener('click', function() {
        // تحديث حالة الأزرار
        document.querySelectorAll('.filter-btn').forEach(b => {
            if (b === this) {
                b.style.background = '#3498db';
            } else {
                b.style.background = '#95a5a6';
            }
        });
        
        const status = this.getAttribute('data-status');
        const rows = document.querySelectorAll('.table tbody tr');
        
        rows.forEach(row => {
            const rowStatus = row.getAttribute('data-status');
            if (status === 'all' || rowStatus === status) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
});

// معالجة نموذج الشركة
document.getElementById('companyForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    // حساب الرصيد النهائي مع الإشارة الصحيحة
    const openingBalance = parseFloat(document.getElementById('opening_balance').value) || 0;
    const balanceType = document.getElementById('balance_type').value;
    const finalBalance = balanceType === 'debit' ? openingBalance : -openingBalance;
    formData.set('opening_balance', finalBalance);
    
    fetch('ajax_companies.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'تم الحفظ بنجاح',
                text: data.message,
                timer: 2000,
                showConfirmButton: false
            }).then(() => {
                hideCompanyModal();
                location.reload();
            });
        } else {
            Swal.fire('خطأ', data.message, 'error');
        }
    })
    .catch(error => {
        Swal.fire('خطأ', 'حدث خطأ أثناء حفظ البيانات', 'error');
    });
});
</script>