<?php
include 'views/layout/header.php';
?>

<div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 0; margin: 5px auto; max-width: 1200px;">
    <div class="card-header" style="background: #2c3e50; color: white; padding: 15px 20px; border-bottom: 3px solid #1a252f; margin-bottom: 0;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-weight: 600; font-size: 18px;">
                <i class="fas fa-user-plus" style="margin-left: 8px;"></i>
                إضافة مستخدم جديد
            </h2>
            <div style="font-size: 12px; opacity: 0.8;">
                <span class="badge" style="background: #2ecc71; padding: 4px 8px; border-radius: 0;">مستخدم جديد</span>
            </div>
        </div>
    </div>

    <div class="card-body" style="padding: 0;">
        <?php if (!empty($error)): ?>
        <div class="alert alert-danger" style="margin: 0; border-radius: 0; border: none; border-bottom: 1px solid #e74c3c; background: #ffe6e6; padding: 12px 20px; display: flex; align-items: center;">
            <i class="fas fa-exclamation-circle" style="margin-left: 10px; color: #e74c3c;"></i>
            <span><?php echo htmlspecialchars($error); ?></span>
        </div>
        <?php endif; ?>

        <!-- Loader Overlay -->
        <div id="loadingOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255,255,255,0.9); z-index: 9999; justify-content: center; align-items: center; flex-direction: column;">
            <div class="loader" style="width: 50px; height: 50px; border: 5px solid #f3f3f3; border-top: 5px solid #3498db; border-radius: 50%; animation: spin 1s linear infinite; margin-bottom: 20px;"></div>
            <div style="color: #2c3e50; font-size: 16px; font-weight: 500;">جاري إنشاء المستخدم الجديد...</div>
            <div style="color: #7f8c8d; font-size: 14px; margin-top: 10px;">يرجى الانتظار</div>
        </div>

        <form method="POST" action="" id="userForm" onsubmit="showLoader()">
            <div style="padding: 25px;">
                <!-- المعلومات الأساسية -->
                <div class="form-section" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #ecf0f1;">
                    <div style="display: flex; align-items: center; margin-bottom: 20px;">
                        <div style="width: 4px; height: 20px; background: #3498db; margin-left: 10px;"></div>
                        <h3 style="margin: 0; font-size: 16px; color: #2c3e50; font-weight: 600;">
                            <i class="fas fa-user-circle" style="margin-left: 8px; color: #3498db;"></i>
                            المعلومات الأساسية للمستخدم الجديد
                        </h3>
                    </div>
                    
                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="username" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> اسم المستخدم
                            </label>
                            <input type="text" class="form-control" id="username" name="username" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; transition: border-color 0.3s;"
                                   onfocus="this.style.borderColor='#3498db'; this.style.boxShadow='0 0 0 2px rgba(52,152,219,0.2)';"
                                   onblur="this.style.borderColor='#bdc3c7'; this.style.boxShadow='none';"
                                   value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>"
                                   placeholder="أدخل اسم المستخدم">
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> اسم المستخدم الذي سيتم استخدامه لتسجيل الدخول
                            </small>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="email" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> البريد الإلكتروني
                            </label>
                            <input type="email" class="form-control" id="email" name="email" required 
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                   value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>"
                                   placeholder="example@domain.com">
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-envelope"></i> البريد الإلكتروني الرسمي للمستخدم
                            </small>
                        </div>
                    </div>

                    <div class="row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                        <div class="form-group">
                            <label class="form-label" for="password" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> كلمة المرور
                            </label>
                            <input type="password" class="form-control" id="password" name="password" required
                                   style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px;"
                                   placeholder="أدخل كلمة المرور">
                            <div style="display: flex; align-items: center; margin-top: 5px;">
                                <button type="button" id="togglePassword" 
                                        style="background: none; border: none; color: #3498db; cursor: pointer; font-size: 12px; padding: 0; margin-left: 10px;">
                                    <i class="fas fa-eye"></i> إظهار/إخفاء
                                </button>
                                <small style="color: #95a5a6; font-size: 12px;">
                                    <i class="fas fa-info-circle" style="margin-right: 5px;"></i>
                                    يجب أن تكون 6 أحرف على الأقل
                                </small>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label" for="role_id" style="display: block; margin-bottom: 8px; color: #2c3e50; font-weight: 500; font-size: 14px;">
                                <span style="color: #e74c3c;">*</span> الدور
                            </label>
                            <select class="form-control" id="role_id" name="role_id" required
                                    style="width: 100%; padding: 10px 12px; border: 1px solid #bdc3c7; border-radius: 0; font-size: 14px; background: white; cursor: pointer;">
                                <option value="">اختر الدور</option>
                                <?php foreach ($roles as $role): ?>
                                    <option value="<?php echo $role['id']; ?>" 
                                            <?php echo (($_POST['role_id'] ?? '') == $role['id']) ? 'selected' : ''; ?>
                                            style="padding: 5px;">
                                        <?php echo htmlspecialchars($role['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <small style="color: #95a5a6; font-size: 12px; display: block; margin-top: 5px;">
                                <i class="fas fa-user-tag"></i> حدد صلاحيات المستخدم في النظام
                            </small>
                        </div>
                    </div>
                </div>

                <!-- نصائح لأمان أفضل -->
                <div class="form-section" style="margin-bottom: 30px; padding: 15px; background: #fff8e1; border-left: 4px solid #f39c12;">
                    <div style="display: flex; align-items: center; margin-bottom: 10px;">
                        <i class="fas fa-shield-alt" style="margin-left: 8px; color: #f39c12;"></i>
                        <h4 style="margin: 0; font-size: 14px; color: #e67e22; font-weight: 600;">
                            نصائح لأمان أفضل:
                        </h4>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(250px, 1fr)); gap: 10px; font-size: 12px;">
                        <div style="background: white; padding: 10px; border: 1px solid #fdebd0;">
                            <div style="color: #e67e22; font-weight: bold; margin-bottom: 5px;">
                                <i class="fas fa-key" style="margin-left: 5px;"></i>
                                كلمة مرور قوية
                            </div>
                            <div style="color: #7f8c8d;">
                                استخدم مزيجاً من الأحرف الكبيرة والصغيرة والأرقام والرموز
                            </div>
                        </div>
                        <div style="background: white; padding: 10px; border: 1px solid #fdebd0;">
                            <div style="color: #e67e22; font-weight: bold; margin-bottom: 5px;">
                                <i class="fas fa-user-secret" style="margin-left: 5px;"></i>
                                مبدأ أقل صلاحية
                            </div>
                            <div style="color: #7f8c8d;">
                                امنح المستخدم أقل صلاحية ممكنة لأداء مهامه
                            </div>
                        </div>
                        <div style="background: white; padding: 10px; border: 1px solid #fdebd0;">
                            <div style="color: #e67e22; font-weight: bold; margin-bottom: 5px;">
                                <i class="fas fa-envelope" style="margin-left: 5px;"></i>
                                بريد إلكتروني رسمي
                            </div>
                            <div style="color: #7f8c8d;">
                                استخدم البريد الإلكتروني الرسمي للمؤسسة
                            </div>
                        </div>
                    </div>
                </div>

                <!-- شرح الأدوار -->
                <div class="form-section" style="margin-bottom: 30px; padding: 15px; background: #f8f9fa; border-left: 4px solid #3498db;">
                    <div style="display: flex; align-items: center; margin-bottom: 10px;">
                        <i class="fas fa-user-shield" style="margin-left: 8px; color: #3498db;"></i>
                        <h4 style="margin: 0; font-size: 14px; color: #2c3e50; font-weight: 600;">
                            شرح الأدوار المتاحة:
                        </h4>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 10px; font-size: 12px;">
                        <?php foreach ($roles as $role): ?>
                        <div style="background: white; padding: 10px; border: 1px solid #ecf0f1;">
                            <div style="color: #3498db; font-weight: bold; margin-bottom: 5px;">
                                <?php echo htmlspecialchars($role['name']); ?>
                            </div>
                            <div style="color: #7f8c8d; font-size: 11px;">
                                <?php 
                                $descriptions = [
                                    'admin' => 'صلاحيات كاملة على النظام',
                                    'مدير' => 'إدارة المستخدمين والمحتوى',
                                    'محرر' => 'تحرير المحتوى فقط',
                                    'مشاهد' => 'عرض المحتوى دون تعديل',
                                    'user' => 'صلاحيات استخدام النظام الأساسية',
                                    'موظف' => 'صلاحيات محددة للموظفين'
                                ];
                                echo $descriptions[$role['name']] ?? $descriptions[strtolower($role['name'])] ?? 'صلاحيات محددة';
                                ?>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- معلومات التفعيل -->
                <div class="form-section" style="margin-bottom: 30px; padding: 15px; background: #e8f4fc; border-left: 4px solid #3498db;">
                    <div style="display: flex; align-items: center; margin-bottom: 10px;">
                        <i class="fas fa-bell" style="margin-left: 8px; color: #3498db;"></i>
                        <h4 style="margin: 0; font-size: 14px; color: #2c3e50; font-weight: 600;">
                            ملاحظات هامة:
                        </h4>
                    </div>
                    <div style="font-size: 13px; color: #2c3e50;">
                        <div style="display: flex; align-items: flex-start; margin-bottom: 8px;">
                            <i class="fas fa-check-circle" style="color: #2ecc71; margin-left: 8px; margin-top: 2px;"></i>
                            <span>سيتم إنشاء المستخدم وسيتمكن من تسجيل الدخول فوراً</span>
                        </div>
                        <div style="display: flex; align-items: flex-start;">
                            <i class="fas fa-check-circle" style="color: #2ecc71; margin-left: 8px; margin-top: 2px;"></i>
                            <span>يمكنك تعديل بيانات المستخدم في أي وقت من قائمة المستخدمين</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer Buttons -->
            <div style="background: #f8f9fa; padding: 15px 25px; border-top: 1px solid #ecf0f1; display: flex; justify-content: space-between; align-items: center;">
                <div style="font-size: 12px; color: #7f8c8d;">
                    <i class="fas fa-exclamation-triangle" style="margin-left: 5px;"></i>
                    الحقول المميزة بـ <span style="color: #e74c3c;">*</span> إجبارية
                </div>
                
                <div style="display: flex; gap: 10px;">
                    <a href="users.php" class="btn" 
                       style="padding: 8px 20px; background: #95a5a6; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; transition: background 0.3s;"
                       onmouseover="this.style.background='#7f8c8d'"
                       onmouseout="this.style.background='#95a5a6'">
                        <i class="fas fa-times" style="margin-left: 8px;"></i>
                        إلغاء
                    </a>
                    <button type="submit" class="btn" 
                            style="padding: 8px 25px; background: #2ecc71; color: white; border: none; border-radius: 0; font-size: 14px; cursor: pointer; display: inline-flex; align-items: center; transition: background 0.3s;"
                            onmouseover="this.style.background='#27ae60'"
                            onmouseout="this.style.background='#2ecc71'">
                        <i class="fas fa-save" style="margin-left: 8px;"></i>
                        حفظ المستخدم الجديد
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .form-control:focus, select:focus {
        outline: none;
    }
    
    .alert-error {
        display: none;
    }
    
    /* Additional styling for better visual */
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-label {
        display: block;
        margin-bottom: 8px;
        color: #2c3e50;
        font-weight: 500;
        font-size: 14px;
    }
    
    select {
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='%232c3e50' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3e%3cpolyline points='6 9 12 15 18 9'%3e%3c/polyline%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 10px center;
        background-size: 15px;
        padding-right: 35px !important;
    }
</style>

<script>
function showLoader() {
    // Validate form first
    if (validateForm()) {
        document.getElementById('loadingOverlay').style.display = 'flex';
        return true;
    }
    return false;
}

function validateForm() {
    const usernameField = document.getElementById('username');
    const emailField = document.getElementById('email');
    const passwordField = document.getElementById('password');
    const roleField = document.getElementById('role_id');
    let isValid = true;
    
    // Reset styles
    usernameField.style.borderColor = '#bdc3c7';
    usernameField.style.boxShadow = 'none';
    emailField.style.borderColor = '#bdc3c7';
    emailField.style.boxShadow = 'none';
    passwordField.style.borderColor = '#bdc3c7';
    passwordField.style.boxShadow = 'none';
    roleField.style.borderColor = '#bdc3c7';
    roleField.style.boxShadow = 'none';
    
    // Validate username
    if (!usernameField.value.trim()) {
        usernameField.style.borderColor = '#e74c3c';
        usernameField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    } else if (usernameField.value.trim().length < 3) {
        usernameField.style.borderColor = '#e74c3c';
        usernameField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        alert('اسم المستخدم يجب أن يكون على الأقل 3 أحرف');
        isValid = false;
    }
    
    // Validate email
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailField.value.trim()) {
        emailField.style.borderColor = '#e74c3c';
        emailField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    } else if (!emailRegex.test(emailField.value.trim())) {
        emailField.style.borderColor = '#e74c3c';
        emailField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        alert('الرجاء إدخال بريد إلكتروني صالح');
        isValid = false;
    }
    
    // Validate password
    if (!passwordField.value.trim()) {
        passwordField.style.borderColor = '#e74c3c';
        passwordField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    } else if (passwordField.value.length < 6) {
        passwordField.style.borderColor = '#e74c3c';
        passwordField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        alert('كلمة المرور يجب أن تكون على الأقل 6 أحرف');
        isValid = false;
    }
    
    // Validate role
    if (!roleField.value) {
        roleField.style.borderColor = '#e74c3c';
        roleField.style.boxShadow = '0 0 0 2px rgba(231,76,60,0.2)';
        isValid = false;
    }
    
    if (!isValid) {
        alert('الرجاء تعبئة جميع الحقول الإجبارية بشكل صحيح');
        return false;
    }
    
    return true;
}

// Toggle password visibility
document.getElementById('togglePassword').addEventListener('click', function() {
    const passwordField = document.getElementById('password');
    const icon = this.querySelector('i');
    
    if (passwordField.type === 'password') {
        passwordField.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        passwordField.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
});

// Add input event listeners to clear error styles
document.querySelectorAll('.form-control').forEach(field => {
    field.addEventListener('input', function() {
        if (this.value.trim()) {
            this.style.borderColor = '#bdc3c7';
            this.style.boxShadow = 'none';
        }
    });
});

// Clear error style on select change
document.getElementById('role_id').addEventListener('change', function() {
    if (this.value) {
        this.style.borderColor = '#bdc3c7';
        this.style.boxShadow = 'none';
    }
});

// Password strength indicator (optional enhancement)
document.getElementById('password').addEventListener('input', function() {
    const password = this.value;
    const strengthIndicator = document.getElementById('passwordStrength');
    
    if (!strengthIndicator) {
        // Create strength indicator if it doesn't exist
        const indicator = document.createElement('small');
        indicator.id = 'passwordStrength';
        indicator.style.display = 'block';
        indicator.style.marginTop = '5px';
        indicator.style.fontSize = '12px';
        this.parentNode.appendChild(indicator);
    }
    
    let strength = 'ضعيفة';
    let color = '#e74c3c';
    
    if (password.length >= 8) {
        strength = 'متوسطة';
        color = '#f39c12';
    }
    if (password.length >= 10 && /[A-Z]/.test(password) && /[0-9]/.test(password)) {
        strength = 'قوية';
        color = '#2ecc71';
    }
    
    document.getElementById('passwordStrength').innerHTML = 
        `<i class="fas fa-shield-alt" style="margin-right: 5px; color: ${color};"></i>` +
        `قوة كلمة المرور: <span style="color: ${color}; font-weight: bold;">${strength}</span>`;
});

// Show loader if page is taking time to submit (fallback)
setTimeout(() => {
    const loader = document.getElementById('loadingOverlay');
    if (loader && loader.style.display === 'flex') {
        const messages = loader.querySelectorAll('div');
        if (messages.length >= 2) {
            messages[1].textContent = 'لا يزال جاري معالجة البيانات...';
            messages[2].textContent = 'قد تستغرق العملية وقتاً أطول من المتوقع';
        }
    }
}, 5000);
</script>

<?php
include 'views/layout/footer.php';
?>